/*	LoadICE.c - Edit 1

	LoadICE Version 4
	Copyright (C) 1990-99 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	 - LoadICE application: A ROM management utility for the PromICE
	
*/
#ifdef WIN32
#include <windows.h>
#endif

#include <stdio.h>
#include <string.h>
#include <signal.h>
#ifndef UNIX
#include <process.h>
#endif
#include "piconfig.h"
#include "pistruct.h"

char *liverNT="LoadICE version 4.0b for Windows NT\n(C) Copyright 1989-99 Grammar Engine Inc.";
char *liver95="LoadICE version 4.0b for Windows 95/98\n(C) Copyright 1989-99 Grammar Engine Inc.";
char *liversu="LoadICE version 4.0b for SUN/OS4\n(C) Copyright 1989-99 Grammar Engine Inc.";
char *liverso="LoadICE version 4.0b for SUN/Solaris(OS5)\n(C) Copyright 1989-99 Grammar Engine Inc.";
char *liverux="LoadICE version 4.0b for Generic UNIX\n(C) Copyright 1989-99 Grammar Engine Inc.";
char *liverdo="LoadICE version 4.0b for MS-DOS/Windows 3.xx\n(C) Copyright 1989-99 Grammar Engine Inc.";
char *liver;

extern void piinit(void);
extern void fiinit(void);
extern void pishell(void);
extern void pi_beep(void);
extern void pcexit(void);
extern void pikick(void);
void licatch(int sig);
void liclick(int sig);

#ifdef	WIN32
void CALLBACK piTimeProc(UINT uID, UINT uMsg, DWORD dwUser, DWORD dw1, DWORD dw2)
{
	if ((piflags&PiNE) && (!pibusy))
		pikick();
}
#endif

void main(int argc,char **argv)
	{
	char *tp;

#ifdef	WIN32
	DWORD dwVersion;
#endif	
	piinit();
	fiinit();

#ifdef	WIN32
	dwVersion = GetVersion();
 

	if (dwVersion < 0x80000000)                // Windows NT
	{
		liver = liverNT;
		pxflags |= PONT;
	}
	else if ((LOBYTE(LOWORD(dwVersion))) < 4)        // Win32s
	{
		liver = liverdo;
		pxflags |= POLD;
	}
	else         // Windows 95
	{
		liver = liver95;
		pxflags |= PO95;
	}
#endif
#ifdef	MSDOS
	liver = liverdo;
	pxflags |= POLD;
#endif
#ifdef UNIX
	liver = liverux;
#endif
#ifdef	SUN
	liver = liversu;
#endif
#ifdef	SOLARIS
	liver = liverso;
#endif

	setbuf(stdout, NULL);

	if (pxdisp&PXVH)
		printf("\n%s\n",liver);

	if (argc > 1)
		{
		tp = pxcline;
		while (--argc)
			{
			strcpy(tp, *++argv);
			tp += strlen(tp);
			*tp++ = ' ';
			}
		*--tp = '\0';
		}

	signal(SIGINT,licatch);

#ifdef	WIN32
	SetConsoleTitle(liver);
	timeSetEvent(30000, 100, piTimeProc, 0, TIME_PERIODIC);
#endif
#ifdef	UNIX
#ifdef	FASTP
	signal(SIGALRM, liclick);
	alarm(PIC_ARM);
#endif
#endif
	pishell();

	if (pxdisp&PXVH)
		if (pxexitv)
			printf("\n\nLoadICE Exiting with Errors - Exit Code %d\n",pxexitv);
		else
			printf("\n\nLoadICE Exiting with NO Errors\n");

	exit(pxexitv);
	}

/* `licatch` - signal catcher to terminate the application */

void licatch(int sig)
	{
	if (piflags&PiER)
		piflags &= ~PiUP;
	pcexit();

	printf("\n\nLoadICE Terminating due to Control-C - Exit Code %d\n",pxexitv);

	exit(pxexitv);
	}

/* `liclick` - signal catcher to kick PromICE */

#ifdef UNIX
void liclick(int sig)
	{
#ifdef FASTP
	if ((piflags&PiNE) && (!pibusy))
		pikick();
	signal(SIGALRM,liclick);
	alarm(PIC_ARM);
#endif
	}
#endif
