#!/bin/bash
#
# (c) Copyright 2002 Hewlett-Packard Development Company, L.P.
#

# source function library
if [ -f /etc/rc.d/init.d/functions ]; then
. /etc/rc.d/init.d/functions
elif [ -f /etc/rc.config ]; then
. /etc/rc.config
elif [ -f /etc/rc.d/functions ]; then
. /etc/rc.d/functions
elif [ -f /etc/rc.status ]; then
. /etc/rc.status
fi


if [ -z "$LOGFILE" ]; then
LOGFILE=/var/spool/compaq/cma.log
fi

#different distros put pidof in different places
if [ -f /sbin/pidof ]; then
  PIDOF=/sbin/pidof
elif [ -f /bin/pidof ]; then
  PIDOF=/bin/pidof
fi

#NAME="agent name"
#PNAME="cmaagentd"
#PFLAGS=

#chkhttpserverconfig () {
#  unset HPWEBSETUP
#  if [ -x /opt/compaq/foundation/etc/hpwebsetup ]; then
#    /opt/compaq/foundation/etc/hpwebsetup -q: >/dev/null 2>&1
#    if [ $? != 4 ]; then
#      cmaerr "ERROR: Can't start the Web agent. HP HTTP server must be configured"
#      cmaerr "       first. The minimum configuration required is the \"administrator\""
#      cmaerr "       password which can be configured with following command:"
#      cmaerr "       /opt/compaq/foundation/etc/hpwebsetup -pA:'yourpasswd' -f"
#    fi
#  fi
#  return 0
#}

cmaerr () {
  echo "  " $* >&2
  echo "  " $* >>$LOGFILE 2>&1
}

cmaecho () {
  echo "  " $*
  echo "  " $* >>$LOGFILE 2>&1
}

cmaechon () {
  echo -n "  " $*
  echo -n "  " $* >>$LOGFILE 2>&1
}

showsuccess()
{
if [ -f /etc/rc.d/init.d/functions ]; then
  echo_success
elif [ -f /etc/rc.status ]; then
  rc_reset
  rc_status -v
else
  echo -ne "\t\t[ SUCCESS ]\n"
fi

}
showfailure()
{
if [ -f /etc/rc.d/init.d/functions ]; then
   echo_failure
elif [ -f /etc/rc.status ]; then
   rc_failed
else
  echo -ne "\t\t[ FAILED ]\n"
fi
}

stopproc () {
	rc=1
	pidlist=`$PIDOF -o $$ $1`
  	for i in `seq 1 25`; do
		if [ -z "$pidlist" ]; then
			rc=0	
			break
		fi
		if [ "$i" = "1" ]; then
			kill $pidlist 2>/dev/null
		elif [ "$i" = "22" ]; then
			kill -9 $pidlist 2>/dev/null
		else
			sleep 1 
		fi
		pidlist=`$PIDOF -o $$ $1`
	done
	return $rc
}

RETVAL=0
PATH=/opt/compaq/foundation/bin:/opt/compaq/server/bin:/opt/compaq/hpasmd/bin:/opt/compaq/storage/bin:$PATH
#RHEL3 U3 did not like this, if LD_ASSUME_KERNEL needs to be set do it
#in the individual scripts 
#[ -z "$LD_ASSUME_KERNEL" ] && export LD_ASSUME_KERNEL=2.4.1
case "$1" in
  start)
	$STARTADDON	
	RETVAL=$?
	if [ $RETVAL -eq 0 ]; then
		cmaechon "Starting $NAME ($PNAME): "
		pidlist=`$PIDOF -o $$ $PNAME`
		if [ -z "$pidlist" ]; then
	  		$PNAME $PFLAGS < /dev/null >> $LOGFILE 2>&1 &
	  		RETVAL=$?
		else
	  		RETVAL=1
		fi
	fi
#	cmaecho
	;;
  stop)
	cmaechon "Shutting down $NAME ($PNAME): "
	stopproc $PNAME 
	RETVAL=$?
        if [ -n "$STOPADDON" ]; then
	   cmaecho
        fi
	$STOPADDON
#	cmaecho
	;;
  restart)
	$0 stop
	$0 start
	RETVAL=$?
	;;
  status)
        if [ -n "$STATUSADDON" ]; then
	   cmaecho
        fi
	$STATUSADDON
	cmaecho
        pid=`$PIDOF -o $$ -o $PPID -o %PPID -x $PNAME`
        if [ -n "$pid" ]; then
                cmaechon "$PNAME is running..."
        else
                cmaechon "$PNAME is stopped..."
        fi
	RETVAL=$?
	;;
  *)
	cmaecho "Usage: $PNAME {start|stop|restart|status}"
	exit 1
esac


if [ $RETVAL -eq 0 ]; then
showsuccess
else
showfailure
fi

if [ "$1" = "start" -o "$1" = "stop" -o "$1" = "status" ]; then
cmaecho
fi

exit $RETVAL
