write direct -1,10
org &c000
limit &ffff
run 0
	x	equ 240
	y	equ 100
	kl_add_frame_fly	equ &bcda
	kl_del_frame_fly	equ &bcdd
	km_test_key		equ &bb1e
	hi_kl_curr_selection	equ &b912
	hi_kl_probe_rom		equ &b915
	txt_output		equ &bb5a

	db 1					;hintergrund-rom
	db 1,0,0				;version
	defw cmdtbl
	jp init
	jp amslinf
cmdtbl	db "AMSLog","o"+&80
	db "AMSLOGOINF","O"+&80,0
init	push de:push bc:push hl			;speichergrenzen sichern
	ld c,0:call hi_kl_probe_rom:ld a,2:cp h:jr nc,ogcpc ;old generation cpc?
	ld hl,asicdata				;hl zeigt auf freischaltsequenz
	ld a,17					;laenge der freischaltsequenz
	ld b,&bc				;bc datenregister
	di
loop1	ld c,(hl):out (c),c			;byte senden
	inc hl					;hl zeit auf naechstes byte
	dec a:jr nz,loop1			;liegen weitere bytes an?
	ei
	ld bc,&7fb8:out (c),c			;asic-ram einblenden
	ld hl,&4000:xor a:ld (hl),a:ld de,&4001:ld bc,&fff:ldir ;sprites loeschen
	ld de,&6422:ld hl,colors:ld bc,30:ldir	;spritefarben laden
	ld de,&6000:ld hl,sprdata:ld bc,8*15:ldir ;spritekoordinaten laden
	ld bc,&7fa0:out (c),c			;asic-ram ausblenden
	pop hl
	ld de,-10:add hl,de			;speicher reservieren
	push hl					;neue speicherobergrenze sichern
	inc hl:push hl:pop ix			;ix zeigt auf arbeitsspeicher des roms (gleichzeitig beginn des ticker-blocks)
						;aufbau des frame flyback blocks:
						;byte 0 und 1 fuer den hangel-pointer der frame flyback chain
						;jetzt folgt der event-block:
						;byte 2 und 3 fuer den hangel-pointer in einer pending queue
	xor a:ld (ix+4),a			;byte 4 kickzahler und steuerbyte
	ld a,%10000000:ld (ix+5),a		;byte 5 asynchron und far adress
	ld a,ihandle:ld (ix+6),a		;byte 6 und 7 adresse der behandlungsroutine
	ld a,ihandle/256:ld (ix+7),a		;/
	call hi_kl_curr_selection:ld (ix+8),a	;byte 8 ROM-Nr.
	xor a:ld (ix+9),a			;byte 9 ist die Variable fuer die behandlungsroutine					
	call kl_add_frame_fly			;interrupt initialisieren	
ogcpc	scf 					;rom erfolgreich initialisiert
	pop hl					;neue speicherobergrenze wiederherstellen
	pop bc:pop de				;speichergrenzen wiederherstellen
	ret
						;interrupt-behandlungsroutine
ihandle	ld de,3:add hl,de			;hl zeigt auf zaehler-variable
	ld a,(hl)
	cp 41:ret z				;keine weitere interruptbehandlung mehr?
	cp 40:jp z,logooff			;nachsehen ob taste gedrueckt ist
	push hl					;zeiger auf zaehler-variable sichern
	ld bc,&7fb8:out (c),c			;asic-ram einblenden
	push af					;zaehler sichern
	ld l,a:ld h,0				;zaehler in hl
	add hl,hl:add hl,hl:ld de,adrtbl:add hl,de
	push ix
	push hl:pop ix
	ld e,(hl):ld d,(ix+1)
	ld l,(ix+2):ld h,(ix+3)
	ldi:ldi:ldi:ldi: ldi:ldi:ldi:ldi :ldi:ldi:ldi:ldi: ldi:ldi:ldi:ldi 
	push hl:ld hl,&300-16:add hl,de:ex de,hl:pop hl
	ldi:ldi:ldi:ldi: ldi:ldi:ldi:ldi :ldi:ldi:ldi:ldi: ldi:ldi:ldi:ldi 
	push hl:ld hl,&300-16:add hl,de:ex de,hl:pop hl
	ldi:ldi:ldi:ldi: ldi:ldi:ldi:ldi :ldi:ldi:ldi:ldi: ldi:ldi:ldi:ldi 
	push hl:ld hl,&300-16:add hl,de:ex de,hl:pop hl
	ldi:ldi:ldi:ldi: ldi:ldi:ldi:ldi :ldi:ldi:ldi:ldi: ldi:ldi:ldi:ldi 
	push hl:ld hl,&300-16:add hl,de:ex de,hl:pop hl
	ldi:ldi:ldi:ldi: ldi:ldi:ldi:ldi :ldi:ldi:ldi:ldi: ldi:ldi:ldi:ldi 
	ld ix,&6002				;ix zeigt auf y-koordnate von sprite 0
	ld a,(ix):dec a				;neue koordinate ausrechnen
	ld (ix),a:ld (ix+24),a:ld (ix+48),a:ld (ix+72),a:ld (ix+96),a
	ld ix,&6002+8:add 16
	ld (ix),a:ld (ix+24),a:ld (ix+48),a:ld (ix+72),a:ld (ix+96),a
	ld ix,&6002+16:add 16
	ld (ix),a:ld (ix+24),a:ld (ix+48),a:ld (ix+72),a:ld (ix+96),a
	pop ix
	pop af					;zaehler holen
	pop hl					;zeiger auf zaehler-variable holen
	inc a:ld (hl),a				;hochzaehlen
	ld bc,&7fa0:out (c),c			;asic-ram ausblenden
	ret

logooff	push hl
	ld a,21:call km_test_key		;shift gedrueckt?
	pop hl
	ret z					;dann weiter
	ld bc,&7fb8:out (c),c			;asic-ram einblenden
	xor a:ld ix,&6004						;sprites ausblenden
	ld (ix),a	:ld (ix+8),a	:ld (ix+16),a	:ld (ix+24),a	;   /
	ld (ix+32),a	:ld (ix+40),a	:ld (ix+48),a	:ld (ix+56),a	;  /
	ld (ix+72),a	:ld (ix+80),a	:ld (ix+88),a	:ld (ix+96),a	; /
	ld (ix+104),a	:ld (ix+112),a	:ld (ix+64),a			;/
	ld bc,&7fa0:out (c),c			;asic-ram ausblenden
	ld a,41:ld (hl),a
	ld de,-9:add hl,de:call kl_del_frame_fly	;interrupt loeschen
	ret

adrtbl	defw &4000,		logo00
	defw &4000+16,		logo01
	defw &4000+32,	logo02
	defw &4000+48,	logo03
	defw &4000+64,	logo04
	defw &4000+80,	logo05
	defw &4000+96,	logo06
	defw &4000+112,	logo07
	defw &4000+128,	logo08
	defw &4000+144,	logo09
	defw &4000+160,	logo10
	defw &4000+176,	logo11
	defw &4000+192,	logo12
	defw &4000+208,	logo13
	defw &4000+224,	logo14
	defw &4000+240,	logo15
	defw &4000+256,	logo16
	defw &4000+272,	logo17
	defw &4000+288,	logo18
	defw &4000+304,	logo19
	defw &4000+320,	logo20
	defw &4000+336,	logo21
	defw &4000+352,	logo22
	defw &4000+368,	logo23
	defw &4000+384,	logo24
	defw &4000+400,	logo25
	defw &4000+416,	logo26
	defw &4000+432,	logo27
	defw &4000+448,	logo28
	defw &4000+464,	logo29
	defw &4000+480,	logo30
	defw &4000+496,	logo31
	defw &4000+512,	logo32
	defw &4000+528,	logo33
	defw &4000+544,	logo34
	defw &4000+560,	logo35
	defw &4000+576,	logo36
	defw &4000+592,	logo37
	defw &4000+608,	logo38
	defw &4000+624, logo39


sprdata	defw x+0,y+0:db 09,09,09,09
	defw x+0,y+16:db 09,09,09,09
	defw x+0,y+32:db 09,09,09,09
	
	defw x+32,y+0:db 09,09,09,09
	defw x+32,y+16:db 09,09,09,09
	defw x+32,y+32:db 09,09,09,09

	defw x+64,y+0:db 09,09,09,09
	defw x+64,y+16:db 09,09,09,09
	defw x+64,y+32:db 09,09,09,09

	defw x+96,y+0:db 09,09,09,09
	defw x+96,y+16:db 09,09,09,09
	defw x+96,y+32:db 09,09,09,09

	defw x+128,y+0:db 09,09,09,09
	defw x+128,y+16:db 09,09,09,09
	defw x+128,y+32:db 09,09,09,09
	
asicdata db &ff,0,&ff,&77,&b3,&51,&a8,&d4,&62,&39,&9c,&46,&2b,&15,&8a,&cd,&ee
logo00	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1
logo01	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,1,1,1,1,1,1,1,1,1
logo02	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,1,1,1,1,1,1,1,1,1,1
logo03	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,1,1,1,1,1,1,1,1,1,1
logo04	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,1,1,1,1,1,1,1,1,1,1,1
logo05	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,1,1,1,1,1,1,1,1,1,1,1
logo06	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,1,1,1,1,1,1,1,1,1,1,1,1
logo07	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,1,1,1,1,1,1,1,1,1,1,1,1
logo08	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,1,1,1,1,1,1,1,1,1,1,1,1,1
logo09	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,1,1,1,1,1,1,1,1,1,1,1,1,1
logo10	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1
logo11	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1
logo12	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
logo13	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
logo14	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
logo15	db 1,1,1,1,1,6,7,7,7,7,7,1,1,1,7,7,7,7,7,8,1,7,7,7,7,7,9,1,1,10,11,11,11,11,10,1,1,10,7,7,7,7,7,7,7,7,1,7,12,12,13,13,13,14,5,5,5,5,14,12,12,12,12,7,9,1,1,10,7,7,6,6,6,10,9,1,1,1,1,1
logo16	db 1,1,1,1,1,11,11,11,11,11,11,8,1,1,11,11,11,11,11,9,1,11,11,11,11,11,9,1,6,11,11,11,11,11,11,6,1,6,11,11,11,11,11,11,11,11,1,11,11,11,11,11,11,11,7,5,5,5,14,11,11,11,11,11,10,1,1,6,11,11,11,11,11,11,11,6,1,1,1,1
logo17	db 1,1,1,1,1,11,11,11,11,11,11,9,1,1,11,11,11,11,11,10,8,11,11,11,11,11,9,8,11,11,11,11,11,11,11,11,8,6,11,11,11,11,11,11,11,11,4,11,11,11,11,11,11,11,11,14,5,5,13,11,11,11,11,11,6,1,1,6,11,11,11,11,11,11,11,11,9,1,1,1
logo18	db 1,1,1,1,8,11,11,11,11,11,11,10,1,1,11,11,11,11,11,10,8,11,11,11,11,11,9,9,11,11,11,6,10,11,11,11,9,6,11,11,11,11,11,11,11,11,2,11,11,11,11,13,11,11,11,12,5,5,12,11,11,11,11,11,7,1,1,6,11,11,11,7,11,11,11,11,10,1,1,1
logo19	db 1,1,1,1,9,11,11,11,11,11,11,10,1,1,11,11,11,11,11,6,9,11,11,11,11,11,9,9,11,11,11,9,9,11,11,11,10,1,1,9,11,11,11,6,1,4,5,11,11,11,11,5,12,11,11,7,5,5,12,11,11,11,11,11,11,1,1,6,11,11,11,9,10,11,11,11,6,1,1,1
logo20	db 1,1,1,1,9,11,11,11,7,11,11,6,1,1,11,11,11,11,11,7,10,11,11,11,11,11,9,9,11,11,11,10,9,11,11,11,10,1,1,9,11,11,11,6,1,2,5,11,11,11,11,5,12,11,11,11,5,5,11,11,11,7,11,11,11,1,1,6,11,11,11,9,9,11,11,11,6,1,1,1
logo21	db 1,1,1,1,10,11,11,11,6,11,11,7,1,1,11,11,11,11,11,11,10,11,11,11,11,11,9,9,11,11,11,7,8,1,1,1,1,1,1,9,11,11,11,6,4,5,5,11,11,11,11,5,12,11,11,7,5,5,11,11,11,6,11,11,11,8,1,6,11,11,11,9,9,11,11,11,6,1,1,1
logo22	db 1,1,1,1,10,11,11,11,10,11,11,11,1,1,11,11,11,11,11,11,6,11,11,11,11,11,9,8,11,11,11,11,11,9,1,1,1,1,1,9,11,11,11,6,2,5,5,11,11,11,11,15,11,11,11,12,5,15,11,11,11,10,11,11,11,9,1,6,11,11,11,9,9,11,11,11,6,1,1,1
logo23	db 1,1,1,1,6,11,11,7,10,11,11,11,1,1,11,11,11,7,11,11,7,11,7,11,11,11,9,1,7,11,11,11,11,11,9,1,1,1,1,9,11,11,11,6,5,5,5,11,11,11,11,11,11,11,11,14,5,15,11,11,11,9,11,11,11,9,1,6,11,11,11,9,9,11,11,11,6,1,1,1
logo24	db 1,1,1,1,7,11,11,7,9,11,11,11,8,1,11,11,11,6,11,11,11,11,6,11,11,11,9,1,8,11,11,11,11,11,11,9,1,1,1,9,11,11,11,12,5,5,5,11,11,11,11,11,11,11,14,5,5,14,11,11,11,8,11,11,11,10,1,6,11,11,11,9,9,11,11,11,6,1,1,1
logo25	db 1,1,1,1,11,11,11,6,9,11,11,11,9,1,11,11,11,10,11,11,11,11,6,11,11,11,9,1,1,8,7,11,11,11,11,11,8,1,1,9,11,11,11,13,5,5,5,11,11,11,11,12,11,11,11,14,5,14,11,11,11,1,11,11,11,6,1,6,11,11,11,9,9,11,11,11,6,1,1,1
logo26	db 1,1,1,1,11,11,11,6,8,11,11,11,9,1,11,11,11,10,11,11,11,11,10,11,11,11,9,1,1,1,1,6,11,11,11,11,10,1,1,9,11,11,11,13,5,5,5,11,11,11,11,5,7,11,11,12,5,13,11,11,11,1,7,11,11,7,1,6,11,11,11,9,9,11,11,11,6,1,1,1
logo27	db 1,1,1,8,11,11,11,6,10,11,11,11,10,1,11,11,11,10,7,11,11,11,9,11,11,11,9,8,6,6,6,9,6,11,11,11,6,1,1,9,11,11,11,13,5,5,5,11,11,11,11,5,12,11,11,7,5,6,11,11,11,10,7,11,11,7,1,6,11,11,11,9,9,11,11,11,6,1,1,1
logo28	db 1,1,1,8,11,11,11,11,11,11,11,11,6,1,11,11,11,10,6,11,11,11,9,11,11,11,9,9,11,11,11,10,8,11,11,11,6,1,1,9,11,11,11,13,5,5,5,11,11,11,11,5,12,11,11,11,3,7,11,11,11,11,11,11,11,11,1,6,11,11,11,9,9,11,11,11,6,1,1,1
logo29	db 1,1,1,9,11,11,11,11,11,11,11,11,6,1,11,11,11,10,6,11,11,11,8,11,11,11,9,9,11,11,11,10,1,11,11,11,7,1,1,9,11,11,11,13,5,5,5,11,11,11,11,5,12,11,11,11,4,11,11,11,11,11,11,11,11,11,8,6,11,11,11,9,10,11,11,11,6,1,1,1
logo30	db 1,1,1,10,11,11,11,11,7,11,11,11,7,1,11,11,11,10,10,11,11,7,8,11,11,11,9,8,11,11,11,10,8,11,11,11,7,1,1,9,11,11,11,13,5,5,5,11,11,11,11,5,12,11,11,11,1,11,11,11,11,7,11,11,11,11,8,6,11,11,11,9,6,11,11,11,6,1,1,1
logo31	db 1,1,1,10,11,11,11,10,1,11,11,11,11,1,11,11,11,10,9,11,11,7,8,11,11,11,9,1,11,11,11,7,7,11,11,11,6,1,1,9,11,11,11,13,5,5,5,11,11,11,11,5,12,11,11,11,8,11,11,11,11,1,6,11,11,11,9,6,11,11,11,11,11,11,11,11,10,1,1,1
logo32	db 1,1,1,6,11,11,11,10,1,11,11,11,11,8,11,11,11,10,9,11,11,6,8,11,11,11,9,1,6,11,11,11,11,11,11,11,9,1,1,14,11,11,11,13,5,5,5,11,11,11,11,5,12,11,11,11,9,11,11,11,7,1,10,11,11,11,10,6,11,11,11,11,11,11,11,11,9,1,1,1
logo33	db 1,1,1,7,11,11,11,9,1,7,11,11,11,8,11,11,11,10,8,11,11,10,8,11,11,11,9,1,8,7,11,11,11,11,11,10,1,1,4,15,11,11,11,13,5,5,5,11,11,11,11,5,12,11,11,11,9,11,11,11,7,1,10,11,11,11,6,6,11,11,11,11,11,11,11,6,1,1,1,1
logo34	db 1,1,1,8,8,8,8,1,1,8,8,8,8,1,8,8,8,8,1,8,8,8,1,8,8,8,1,1,1,1,9,6,6,10,8,1,1,1,2,5,15,15,15,3,5,5,5,15,15,15,15,5,3,15,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1
logo35	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
logo36	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
logo37	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
logo38	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
logo39	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1

colors 	db &99,&09, &B7,&03, &C6,&02, &A8,&07, &D5,&00, &DD,&0D, &EE,&0E, &AA,&0A, &BB,&0B, &CC,&0C, &FF,&0F, &FD,&0C, &FC,&0A, &EA,&07, &D7,&03

amslinf	ld hl,msg
loop2	ld a,(hl):or a:ret z
	call txt_output
	inc hl
	jr loop2
msg	db "This useless ROM displays the",10,13
	db "Amstrad logo on the Plus machines.",10,13
	db "It doesn't work with earlier models",10,13
	db "of the Amstrad CPC range.",10,13
	db 164," 2007 Mr. AMS",10,13,0
