@echo off
rem CPCxxx.BAT - start CPCEMU with a special CPC type (and %TMP%\CPCEMU.CFG)
rem Marco Vieth, 30.6.1998

rem Select type 0=CPC464, 1=CPC664, 2=CPC6128, 3=CPC464+, 4=CPC6128+, 5=KC
set CPCTYPE=5

rem Set double quote, if running under Win95.
rem (This allows long filenames.)
set DQ="
if "%winbootdir%"==""  set DQ=

rem Check if TMP directory exists, otherwise use TEMP or exit with error
if "%TMP%"==""  set TMP=%TEMP%
if "%TMP%"==""  goto ERR_NOTMP
if not exist %DQ%%TMP%\NUL%DQ%  goto ERR_NOTMP

rem Does the local configuration file CPCEMU.CFG exist?
rem (It exists if INSTALL.BAT was successful.)
if not exist CPCEMU.CFG  goto ERR_INSTALL_FIRST

rem We do use the configuration in the TMP directory.
rem If this does not exist we will create it.
set CFGFILE=%TMP%\CPCEMU.CFG
if exist %DQ%%CFGFILE%%DQ%  goto EXECUTE

rem Setup
cls
echo CPCEMU v1.5 -- Mini Setup
echo.
echo Language
echo 0  English
echo 1  German
echo 2  French
echo 3  Spanish
echo.
echo (Your choice will be put into "%CFGFILE%")
echo.
rem We use English in case of some error (maybe if no choice exists)
set CPC_LANG=0
choice /c:0123 /t:0,20 "Select Language "
rem the following IFs are ">=" comparisions
if errorlevel 1  set CPC_LANG=0
if errorlevel 2  set CPC_LANG=1
if errorlevel 3  set CPC_LANG=2
if errorlevel 4  set CPC_LANG=3

copy CPCEMU.CFG %CFGFILE%
echo ; >> %CFGFILE%
echo LANGUAGE = %CPC_LANG% >> %CFGFILE%
echo KBD_LANGUAGE = %CPC_LANG% >> %CFGFILE%

rem now we can execute CPCEMU...

:EXECUTE
CPCEMU -c %CFGFILE% -t %CPCTYPE% %1 %2 %3 %4 %5 %6 %7 %8 %9
if errorlevel 2 goto ERR_EMU_FATAL
if errorlevel 1 goto ERR_EMU
goto OK

:ERR_NOTMP
echo The TMP directory "%TMP%" does not exist!
echo Please set the TMP environment variable to an existing directory.
goto EXIT

:ERR_INSTALL_FIRST
echo Configuration file CPCEMU.CFG not found.
echo Please run INSTALL.BAT first.
goto EXIT

:ERR_EMU
echo Some error occured.
goto EXIT

:ERR_EMU_FATAL
echo Some fatal error occured.
goto EXIT

:OK

:EXIT
rem Unset the variables
set CPCTYPE=
set CPC_LANG=
set CFG_FILE=
set DQ=
