CPC6128 EQU     0

EsHL    EQU     EBX
nSHL    EQU     BX
sH      EQU     BH
sL      EQU     BL
EsDE    EQU     EDX
sDE     EQU     DX
sD      EQU     DH
sE      EQU     DL
EsBC    EQU     ECX
sBC     EQU     CX
sB      EQU     CH
sC      EQU     CL
sPC     EQU     SI
sFree   EQU     DI
EsFree  EQU     EDI

LWEsHL  EQU     nsHL
LWEsDE  EQU     sDE
LWEsBC  EQU     sBC

LNnsHL  EQU     sL
HNnsHL  EQU     sH
LNsDE   EQU     sE
HNsDE   EQU     sD
LNsBC   EQU     sC
HNsBC   EQU     sB
LNAX    EQU     AL
HNAX    EQU     [BYTE PTR ES:BP]
LNsPC   EQU     [BYTE PTR ES:BP]
HNsPC   EQU     [BYTE PTR ES:BP]

SColOff EQU     0FD00h

MACRO   instend
        CMP     [intflag],0
        JNE     SpecialOccasion
 	gbpc
 	JMP     [EsFree*2+opcodes]
ENDM

MACRO   GetRSeg Seg,offset
        MOV     BP,offset
        SHR     BP,14
	PUSH    [WORD PTR EBP*2+memmap]
        POP     Seg
ENDM

MACRO   GetWSeg Sg,offset
        MOV     BP,[normramseg]
        MOV     Sg,BP
ENDM

MACRO   GetRESg Seg,offset
        MOV     BP,LW&offset
        SHR     BP,14
	MOV     BP,[EBP*2+memmap]
        MOV     Seg,BP
ENDM

MACRO   GetWESg Sg,offset
        MOV     BP,[normramseg]
        MOV     Sg,BP
ENDM

MACRO   InitPCSeg
        MOV     BP,sPC
        SHR     BP,14
	MOV     BP,[EBP*2+memmap]
        MOV     GS,BP
ENDM

MACRO   gbytead src,dest
	MOV     sFree,LW&src
        SHR     sFree,14
	MOV     sFree,[EsFree*2+memmap]
 	MOV     FS,sFree
	MOV     dest,[BYTE PTR FS:src]
ENDM

MACRO   gwordhl dest
	MOV     sFree,nsHL
        SHR     sFree,14
	MOV     sFree,[EsFree*2+memmap]
	MOV     FS,sFree
	MOV     dest,[WORD PTR FS:nsHL]
ENDM

MACRO   gbyteBP dest
	MOV     sFree,BP
        SHR     sFree,14
	MOV     sFree,[EsFree*2+memmap]
	MOV     FS,sFree
	MOV     dest,[BYTE PTR FS:BP]
ENDM

MACRO   gbytefr dest
	MOV     BP,sFree
        SHR     BP,14
	MOV     BP,[EBP*2+memmap]
	MOV     FS,BP
	MOV     dest,[BYTE PTR FS:sFree]
ENDM

MACRO   gwordBP dest
	MOV     sFree,BP
        SHR     sFree,14
	MOV     sFree,[EsFree*2+memmap]
	MOV     FS,sFree
	MOV     dest,[WORD PTR FS:BP]
ENDM

MACRO   wbyte   src
LOCAL   @novid
        MOV     [BYTE PTR ES:BP],src
        MOV     sFree,BP
        SHR     sFree,14
        ADD     sFree,sFree
        MOV     sFree,[sFree+writevgaoff]
        OR      sFree,sFree
        JS      SHORT @novid
        PUSH    AX
        MOVZX   AX,src
        CALL    DoScr
        POP     AX
@novid:
ENDM

MACRO   wbytefr src
LOCAL   @novid
        MOV     [BYTE PTR ES:sFree],src
        MOV     BP,sFree
        SHR     sFree,14
        ADD     sFree,sFree
        MOV     sFree,[sFree+writevgaoff]
        OR      sFree,sFree
        JS      SHORT @novid
        PUSH    AX
        MOVZX   AX,src
        CALL    DoScr
        POP     AX
@novid:
ENDM

MACRO   wbhl    src
LOCAL   @novid
        MOV     [BYTE PTR ES:nSHL],src
        MOV     sFree,nSHL
        SHR     sFree,14
        ADD     sFree,sFree
        MOV     sFree,[sFree+writevgaoff]
        OR      sFree,sFree
        JS      SHORT @novid
        PUSH    AX
        MOVZX   AX,src
        MOV     BP,nsHL
        CALL    DoScr
        POP     AX
@novid:
ENDM

MACRO   wbytead addr,src
LOCAL   @novid
IFIDNI  <addr>,<EsFree>
Argh!
ENDIF
	MOV     [BYTE PTR ES:addr],src
        MOV     sFree,LW&addr
        SHR     sFree,14
        ADD     sFree,sFree
        MOV     sFree,[sFree+writevgaoff]
        OR      sFree,sFree
        JS      SHORT @novid
        MOV     BP,LW&addr
        PUSH    AX
        MOVZX   AX,src
        CALL    DoScr
        POP     AX
@novid:
ENDM

MACRO   wword   src
LOCAL   @novid,@vidend
IFIDN   <src>,<sFree>
Argh!
ENDIF
	MOV     [WORD PTR ES:BP],src
        MOV     sFree,BP
        SHR     sFree,14
        MOV     sFree,[EsFree*2+writevgaoff]
        OR      sFree,sFree
        JS      SHORT @novid
        PUSH    AX
	PUSH    BP
        MOVZX   AX,LN&src
        CALL    DoScr
	POP     BP
	INC     BP
        MOV     sFree,BP
        SHR     sFree,14
        MOV     sFree,[EsFree*2+writevgaoff]
        OR      sFree,sFree
        JS      SHORT @vidend
        MOVZX   AX,HN&src
	CALL    DoScr
@vidend:
        POP     AX
@novid:
ENDM

MACRO   gbpc
        MOVZX   sFree,[GS:sPC]
 	INC     sPC
ENDM

MACRO   gsbpc
        MOVSX   sFree,[GS:sPC]
	INC     sPC
ENDM

MACRO   getPC
        MOV     sPC,[GS:sPC]
        InitPCSeg
ENDM

MACRO   gbytePC dest                            ; MAY NOT MODIFY 86C FLAG!
	MOV     dest,[BYTE PTR GS:sPC]
	INC     sPC
ENDM

MACRO   gbhl dest
	MOV     BP,nsHL
        SHR     BP,14
	MOV     BP,[WORD PTR EBP*2+memmap]
        MOV     FS,BP
	MOV     dest,[BYTE PTR FS:nsHL]
ENDM

MACRO   gwpc    dest
	MOV     dest,[WORD PTR GS:sPC]
        ADD     sPC,2
ENDM

MACRO   jrd0
	ADD     sPC,sFree
	instend
ENDM

MACRO   flagsetN0
LOCAL   @vocc
	LAHF
	JO      SHORT @vocc
	AND     AH,0F9h
	JMP     simz80l
@vocc:  OR      AH,004h
	AND     AH,0FDh
	instend
ENDM

MACRO   flagsetN1
LOCAL   @vocc
	LAHF
	JO      SHORT @vocc
	AND     AH,0F9h
       	OR      AH,002h
	JMP     simz80l
@vocc:  OR      AH,006h
	instend
ENDM

MACRO   z80dec  reg
        SAHF
        DEC     reg
        flagsetN1
ENDM

MACRO   z80inco reg
LOCAL   @vocc,@ok
        SAHF
        INC     reg
        LAHF
        JO      SHORT @vocc
        AND     AH,0f9h
        JMP     SHORT @ok
@vocc:  OR      AH,4
        AND     AH,0fdh
@ok:
ENDM

MACRO   z80deco reg
LOCAL   @vocc,@ok
        SAHF
        DEC     reg
        LAHF
        JO      SHORT @vocc
        AND     AH,0f9h
        OR      AH,2
        JMP     SHORT @ok
@vocc:  OR      AH,6
@ok:
ENDM

MACRO   z80inc  reg
        SAHF
        INC     reg
        flagsetN0
ENDM

MACRO   addtoc  src,temp
	MOV     temp,AX
	OR      src,src
	LAHF
	AND     temp,0100h
	OR      AX,temp
ENDM

MACRO   ret80                   ;Return from subroutine.
	MOV     BP,[simstack]
	gwordBP sPC
	ADD     BP,2
	MOV     [simstack],BP
        InitPCSeg
	instend
ENDM

MACRO   call80                  ;Call a Z-80 subroutine.
	MOV     BP,[simstack]
        SUB     BP,2
 	MOV     [simstack],BP
        ADD     sPC,2
	wword   sPC
        SUB     sPC,2
        getPC
	instend
ENDM

MACRO   rst80   addr            ;Z-80 RST instruction
	MOV     BP,[simstack]
	SUB     BP,2
	MOV     [simstack],BP
	wword   sPC
	MOV     sPC,addr
        InitPCSeg
	instend
ENDM

MACRO   docyf                   ;Copy 68000's carry flag to Z-80.
LOCAL   @cset
	JC      SHORT @cset
	AND     AH,0ECh
	JMP     simz80l
@cset:  AND     AH,0ECh
        OR      AH,1
	instend
ENDM

MACRO   dozf                    ;Copy 68000's zero flag to Z-80.
LOCAL   @zset                   ; ONLY for BIT instructions
	JNC     SHORT @zset
	AND     AH,03fh
	JMP     simz80l
@zset:  AND     AH,03fh
	OR      AH,040h
	instend
ENDM

MACRO   dozmf                   ;Copy 68000's zero flag to Z-80.
LOCAL   @zset
	JNC     SHORT @zset     ;special version for BIT 7,n
	AND     AH,3fh          ; clear Z, Set M
	OR      AH,80h          ; I hate undocumented stuff
	JMP     simz80l         ; especially if someone uses it
@zset:  AND     AH,7fH
	OR      AH,40H
	instend
ENDM

MACRO   calcind ixiy            ;Calculate (IX+d) or (IY+d).
	gsbpc
	ADD     sFree,[ixiy]
ENDM