; AY-3-8912 Programmable Sound Generator emulation for CPE
; Copyright (c) 1996,97 by Ulrich Doewich
; cyrel@interlog.com

;	v0.01	Oct. 28, 1996 - 22:19
;	v0.02	Oct. 31, 1996 - 23:05	stereo sound support added
;	v0.03	Nov.  3, 1996 - 16:58	44kHz option added
;	v0.04	Nov. 11, 1996 - 16:41	fixed amplitude or envelope test
;	v0.05	Jan. 22, 1997 - 21:46	removed unnecessary odd_flag code
;	v0.06	Jan. 26, 1997 - 00:51	improved envelope emulation
;	v0.07	Jan. 26, 1997 - 18:21	increased accuracy of all calculations
;	v0.08	Jan. 28, 1997 - 23:15	rewrote linear address calculation code
;	v0.09	Feb. 17, 1997 - 23:54	optimized interrupt routine
;	v0.10	Feb. 18, 1997 - 21:29	optimized interrupt routine
;	v0.11	Feb. 18, 1997 - 22:27	new (faster) random number generator
;	v0.12	Mar.  8, 1997 - 11:20	optimized for even-address access
;	v0.13	Mar. 29, 1997 - 19:32	converted to variable tab stops

;	v1.00	Apr. 28, 1997 - 11:20	first public release

ideal
P386

Debug		equ	0

DMA_STATUSPORT	equ	08h
DMA_MASKPORT	equ	0ah
DMA_CLEARPORT	equ	0ch
DMA_MODEPORT	equ	0bh

XX		equ	-1

; from ipe1.asm
extrn		PSGregs:WORD
extrn		SCinstalled:WORD, SCport:WORD, SCirq:WORD, SCdma:WORD
extrn		DMAblocklen:WORD, SCsrate:WORD, stereo_flag:WORD
extrn		usesound:WORD, intflag:WORD

; from snd_sb.asm
extrn		SB_reset:PROC, SB_shutdown:PROC, SB_pause:PROC
extrn		SB_continue:PROC, SB_clrINT:PROC

; from snd_gus.asm
extrn		GUS_reset:PROC, GUS_shutdown:PROC, GUS_pause:PROC
extrn		GUS_continue:PROC, GUS_clrINT:PROC

; from snd_ess.asm
extrn		ESS_reset:PROC, ESS_shutdown:PROC, ESS_pause:PROC
extrn		ESS_continue:PROC, ESS_clrINT:PROC

public		init_SC, setup_DMA, init_mixing, install_handler
public		uninstall_handler
public		sound_reset, sound_shutdown, sound_pause, sound_continue
public		sound_PSGreset, dosound

public		buffer_addr, DMA_addrport, DMA_countport, DMA_mode, DMA_stopmask
public		amp_table

group		DGROUP _stack, _data

segment	 _text	page public 'CODE'
assume		cs:_text
assume		ds:DGROUP

; ________________________________________________________________________

init_SC:
		mov	ax, [SCirq]
		cmp	al, 8
		jge	iSC_highIRQ
		add	al, 8
		mov	[byte ptr PIC_maskport], 21h
		jmp	iSC_setDMA
iSC_highIRQ:
		add	al, 70h - 8
		mov	[byte ptr PIC_maskport], 0a1h
iSC_setDMA:
		mov	[IRQ_intvector], al
		mov	cx, [SCirq]
		and	cl, 7
		mov	al, 1
		shl	al, cl
		mov	[IRQ_stopmask], al
		not	al
		mov	[IRQ_startmask], al

		mov	ax, [SCdma]
		shl	al, 1
		mov	[DMA_addrport], al
		inc	al
		mov	[DMA_countport], al

		mov	bx, [SCdma]
		mov	si, offset DMA_table
		mov	al, [si + bx]
		mov	[DMA_pageport], al
		mov	[DMA_startmask], bl
		add	bl, 4
		mov	[DMA_stopmask], bl
		add	bl, 58h - 4
		mov	[DMA_mode], bl
		clc
		ret

; ________________________________________________________________________

setup_DMA:
		mov	al, [DMA_stopmask]		; init DMA controller
		out	DMA_MASKPORT, al
		mov	al, [DMA_mode]
		out	DMA_MODEPORT, al
		movzx	dx, [DMA_pageport]
		mov	al, [byte ptr buffer_page]
		out	dx, al
		cli
		xor	al, al
		out	DMA_CLEARPORT, al
		movzx	dx, [DMA_addrport]
		mov	ax, [buffer_addr]
		out	dx, al
		mov	al, ah
		out	dx, al
		movzx	dx, [DMA_countport]
		mov	ax, [DMAblocklen]
		shl	ax, 1
		dec	ax
		out	dx, al
		mov	al, ah
		out	dx, al
		sti
		in	al, DMA_STATUSPORT
		mov	dx, DMA_MASKPORT
		mov	al, [DMA_startmask]
		out	dx, al
		ret

; ________________________________________________________________________

init_mixing:
		mov	ax, ds				; get buffer segment
		rol	ax, 4				; rotate page into al
		movzx	bx, al
		and	bl, 00fh			; keep lower nibble 0xh
		and	al, 0f0h			; remove lower nibble
		add	ax, offset soundmem		; add buffer offset
		jnc	im_pageOK
		inc	bl
im_pageOK:
		mov	[buffer_page], bx
		mov	[buffer_addr], ax

		mov	cx, [DMAblocklen]
		shl	cx, 1				; required length * 2
		add	ax, cx
		jnc	im_nocrossing
		mov	[buffer_addr], ax		; update address
		inc	[buffer_page]			; increase page
		mov	ax, offset soundmem
		add	ax, cx
		mov	[soundmem_ptr], ax		; update data pointer
		mov	[curblockptr], ax
im_nocrossing:
		mov	ax, [soundmem_ptr]
		add	ax, cx
		mov	[soundmem_end], ax
		ret

; ________________________________________________________________________

inthandler:
		cli
		pushad
		push	ds

		mov	ax, DGROUP
		mov	ds, ax
generate_voice:
		mov	cl, [byte ptr env_value]
		mov	ch, [byte ptr noise_value]
		mov	dx, [blocklen]
		mov	di, [curblockptr]		; buffer to be filled
		mov	si, [env_idtpos]		; inc/dec table pointer

; ........................................................................

gv_loop:
		cmp	[env_major], 0			; below 16?
		jnz	gv_envnormal
gv_envspecial:
		movzx	bx, [si]
		mov	cl, [amp_table + bx]

		cmp	[env_done], 1
		je	 gv_noise
		inc	si
		mov	al, [si]
		cmp	al, XX
		jne	gv_noise
gv_envsprampdone:
		mov	al, [byte ptr env_shape]
		cmp	al, 8				; 0xxx ?
		jge	gv_envspcontinue
		mov	si, offset env_inctable + 32
		mov	[env_done], 1
		jmp	gv_noise
gv_envspcontinue:
		and	al, 3				; xx00 ?
		jnz	gv_envsphold
		mov	ax, [env_idtorg]
		mov	si, ax
		jmp	gv_noise
gv_envsphold:
		dec	al				; xx01 ?
		jnz	gv_envspalternate
		mov	[env_done], 1
		jmp	gv_noise
gv_envspalternate:
		dec	al				; xx10 ?
		jnz	gv_envsplast
		mov	ax, [env_idtorg]
		add	ax, [env_idtoffs]		; add offs or -offs
		mov	si, ax
		mov	[env_idtorg], ax
		neg	[env_idtoffs]			; reverse direction
		jmp	gv_noise
gv_envsplast:
		mov	ax, [env_idtorg]		; xx11 !
		mov	si, ax
		mov	[env_done], 1
		jmp	gv_noise

; ........................................................................

gv_envnormal:
		dec	[env_rm]
		jnz	gv_noise
		cmp	[env_done], 1
		je	gv_envgetval
		mov	al, [byte ptr env_dir]
		add	[byte ptr env_step], al
gv_envgetval:
		movzx	bx, [byte ptr env_step]
		mov	cl, [byte ptr amp_table + bx]
		cmp	[env_done], 1
		je	gv_envreload

		mov	al, [byte ptr env_target]
		cmp	al, bl				; reach end of ramp?
		jne	gv_envreload

		mov	al, [byte ptr env_shape]
		cmp	al, 8				; 0xxx ?
		jge	gv_envcontinue
		mov	[env_step], 0
		mov	[env_done], 1
		jmp	gv_envreload
gv_envcontinue:
		and	al, 3				; xx00 ?
		jnz	gv_envhold
		test	[env_shape], 4
		jnz	gv_envattack
		mov	[env_step], 16
		mov	[env_target], 0
		mov	[env_dir], -1
		jmp	gv_envreload
gv_envattack:
		mov	[env_step], -1
		mov	[env_target], 15
		mov	[env_dir], 1
		jmp	gv_envreload
gv_envhold:
		dec	al				; xx01 ?
		jnz	gv_envalternate
		mov	[env_done], 1
		jmp	gv_envreload
gv_envalternate:
		dec	al				; xx10 ?
		jnz	gv_envlast
		neg	[env_dir]			; reverse direction
		js	gv_envnegative
		mov	[env_step], -1
		mov	[env_target], 15
		jmp	gv_envreload
gv_envnegative:
		mov	[env_step], 16
		mov	[env_target], 0
		jmp	gv_envreload
gv_envlast:
		mov	[env_done], 1			; xx11 !
		test	[env_shape], 4
		jnz	gv_envlastinc
		mov	[env_step], 15
		jmp	gv_envreload
gv_envlastinc:
		mov	[env_step], 0
gv_envreload:
		mov	ax, [env_major]
		mov	[env_rm], ax
		mov	al, [byte ptr env_fractional]
		add	[byte ptr env_rf], al
		jnc	gv_noise
		inc	[env_rm]

; ........................................................................

gv_noise:
		cmp	[noise_cnt], 0			; frame complete?
		jg	gv_A

		mov	eax, [random_val]
		cmp	[random_cnt], 0			; done with RND value?
		jnz	gv_rotaternd
		mov	[random_cnt], 31		; reset counter
gv_random:
		mov	ebx, 32608410h
		xor	ebx, eax
		jp	gv_rndswap
		ror	ax, 1
gv_rndswap:
		ror	eax, 17
		xor	eax, ebx
gv_rotaternd:
		ror	eax, 1				; reuse same RND value
		mov	[random_val], eax
		dec	[random_cnt]

		and	eax, 1				; even or odd?
		jz	gv_noisereload
		mov	eax, 0ffh
gv_noisereload:
		mov	ch, al
		mov	ax, [noise_cntreld]
		mov	[noise_cnt], ax			; reset noise counter
		mov	al, [byte ptr noise_cntfrac]
		add	[byte ptr noise_cntrf], al
		jnc	gv_A
		inc	[noise_cnt]

; ........................................................................

gv_A:
		cmp	[A_cnt], 0			; frame complete?
		jg	gv_B
		mov	al, [byte ptr A_value]
		not	al				; invert mask
		mov	[byte ptr A_value], al
		mov	ax, [A_cntreload]
		mov	[A_cnt], ax			; reset counter
		mov	al, [byte ptr A_cntfrac]
		add	[byte ptr A_cntrf], al
		jnc	gv_B
		inc	[A_cnt]

; ........................................................................

gv_B:
		cmp	[B_cnt], 0			; frame complete?
		jg	gv_C
		mov	al, [byte ptr B_value]
		not	al				; invert mask
		mov	[byte ptr B_value], al
		mov	ax, [B_cntreload]
		mov	[B_cnt], ax			; reset counter
		mov	al, [byte ptr B_cntfrac]
		add	[byte ptr B_cntrf], al
		jnc	gv_C
		inc	[B_cnt]

; ........................................................................

gv_C:
		cmp	[C_cnt], 0			; frame complete?
		jg	gv_Amix
		mov	al, [byte ptr C_value]
		not	al				; invert mask
		mov	[byte ptr C_value], al
		mov	ax, [C_cntreload]
		mov	[C_cnt], ax			; reset counter
		mov	al, [byte ptr C_cntfrac]
		add	[byte ptr C_cntrf], al
		jnc	gv_Amix
		inc	[C_cnt]

; ........................................................................

gv_Amix:
		mov	al, [byte ptr A_amplitude]
		or	al, al				; use amplitude or
		jns	gv_Atone			;  envelope?
		mov	al, cl
gv_Atone:
		test	[mixer_ctrl], 1			; tone enabled?
		jnz	gv_Atoneoff
		and	al, [byte ptr A_value]
gv_Atoneoff:
		test	[mixer_ctrl], 8			; noise enabled?
		jnz	gv_Bmix
		and	al, ch
gv_Bmix:
		mov	bl, [byte ptr B_amplitude]
		or	bl, bl				; use amplitude or
		jns	gv_Btone			;  envelope?
		mov	bl, cl
gv_Btone:
		test	[mixer_ctrl], 2			; tone enabled?
		jnz	gv_Btoneoff
		and	bl, [byte ptr B_value]
gv_Btoneoff:
		test	[mixer_ctrl], 16		; noise enabled?
		jnz	gv_Cmix
		and	bl, ch
gv_Cmix:
		mov	ah, [byte ptr C_amplitude]
		or	ah, ah				; use amplitude or
		jns	gv_Ctone			;  envelope?
		mov	ah, cl
gv_Ctone:
		test	[mixer_ctrl], 4			; tone enabled?
		jnz	gv_Ctoneoff
		and	ah, [byte ptr C_value]
gv_Ctoneoff:
		test	[mixer_ctrl], 32		; noise enabled?
		jnz	gv_addsample
		and	ah, ch

; ........................................................................

gv_addsample:
		cmp	[stereo_flag], 0
		je	gs_asmono
;		shr	bl, 1				; add 50% of B to
		add	al, bl				;  A and C..
		add	ah, bl
		mov	[word ptr di], ax		; write to mixing buffer
		add	di, 2
		jmp	gs_ascont
gs_asmono:
		add	al, bl
		add	al, ah
		mov	[byte ptr di], al		; write to mixing buffer
		inc	di
gs_ascont:
		dec	[noise_cnt]
		dec	[A_cnt]
		dec	[B_cnt]
		dec	[C_cnt]
		dec	dx
		jnz	gv_loop

		mov	[byte ptr env_value], cl
		mov	[byte ptr noise_value], ch
		cmp	di, [soundmem_end]		; at end of 2nd buffer?
		jb	ih_updateptr
		mov	di, [soundmem_ptr]		; restart with 1st
ih_updateptr:
		mov	[curblockptr], di
		mov	[env_idtpos], si

		call	[sound_clearINT]		; clear on soundcard
		mov	al, 20h
		cmp	[byte ptr IRQ_intvector], 70h
		jb	ih_lowIRQ
		out	0a0h, al			; acknowledge interrupt
ih_lowIRQ:
		out	20h, al				;  with PIC
ih_end:
		pop	ds
		popad
		sti
		iret

; ________________________________________________________________________

install_handler:
		cli
		movzx	dx, [PIC_maskport]
		in	al, dx
		or	al, [IRQ_stopmask]
		out	dx, al

		mov	al, [IRQ_intvector]
		mov	ah, 35h
		int	21h
		mov	[IRQ_oldsegment], es
		mov	[IRQ_oldoffset], bx

		mov	al, [IRQ_intvector]
		mov	dx, offset inthandler
		push	ds
		push	cs
		pop	ds
		mov	ah, 25h
		int	21h
		pop	ds

		movzx	dx, [PIC_maskport]
		in	al, dx
		and	al, [IRQ_startmask]
		out	dx, al

		sti
		ret

; ________________________________________________________________________

uninstall_handler:
		cli
		movzx	dx, [PIC_maskport]
		in	al, dx
		or	al, [IRQ_stopmask]
		out	dx, al

		mov	bx, ds
		mov	al, [IRQ_intvector]
		mov	cl, al
		mov	dx, [IRQ_oldoffset]
		mov	ax, [IRQ_oldsegment]
		mov	ds, ax
		mov	al, cl
		mov	ah, 25h
		int	21h
		mov	ds, bx
		sti
		ret

; ________________________________________________________________________

sound_reset:
		cmp	[SCinstalled], 0		; sound card installed?
		je	sr_exit

		cmp	[SCsrate], 0			; 22kHz sampling rate?
		je	sc_22kHz
		mov	eax, 0b4a23h			; 44kHz value..
		mov	[sound_freqval], eax
sc_22kHz:
		mov	ax, [DMAblocklen]		; check DMA buffer size
		and	ax, 0fch
		cmp	ax, 4				; below minimum of 4?
		jge	sr_validBS
		mov	ax, 64				; default to 64
sr_validBS:
		mov	[DMAblocklen], ax
		cmp	[stereo_flag], 0
		je	sr_notstereo
		shr	ax, 1
sr_notstereo:
		mov	[blocklen], ax			; adjust block length

		mov	bx, [SCinstalled]		; setup sound card
		dec	bx				;  specific jumps..
		shl	bx, 1
		mov	ax, bx
		shl	bx, 2
		add	bx, ax				; times 10
		mov	ax, [SCcode_table + bx + 8]
		mov	[sound_clearINT], ax
		mov	ax, [SCcode_table + bx + 6]
		mov	[sound_continue], ax
		mov	ax, [SCcode_table + bx + 4]
		mov	[sound_pause], ax
		mov	ax, [SCcode_table + bx + 2]
		mov	[SC_shutdown], ax
		mov	ax, [SCcode_table + bx]
		jmp	ax				; reset sound card
sr_exit:
		ret

; ________________________________________________________________________

sound_shutdown:

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

if Debug
		pushad
		mov	ax, 3d02h			; open file read/ write
		mov	dx, offset dbg_name
		int	21h
		jnc	ssdbg_exists
		mov	ax, 3c00h			; create file
		mov	cx, 0				; normal attributes
		mov	dx, offset dbg_name
		int	21h
ssdbg_exists:
		mov	bx, ax
		mov	ax, 4202h			; move file pointer to
		mov	cx, 0				; end of file
		mov	dx, 0
		int	21h

		mov	ax, 4000h			; write to file
		mov	cx, [dbg_offs]
		sub	cx, 2
		mov	dx, offset dbg_buffer
		int	21h

		mov	ax, 3e00h			; close file
		int	21h
		popad
endif

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

		jmp	[SC_shutdown]

; ________________________________________________________________________

sound_PSGreset:
		cmp	[SCinstalled], 0
		je	sPSGr_exit

		mov	[mixer_ctrl], 63		; turn all channels off
		mov	[A_amplitude], 0		; set volume to 0
		mov	[A_value], 0
		mov	[B_amplitude], 0		; set volume to 0
		mov	[B_value], 0
		mov	[C_amplitude], 0		; set volume to 0
		mov	[C_value], 0

		push	bx
		mov	bx, 13				; clear PSG registers..
sPSGr_loop:
		mov	[PSGregs + bx], 0
		dec	bx
		jns	sPSGr_loop
		pop	bx
sPSGr_exit:
		ret

; ________________________________________________________________________

dosound:
		cmp	[SCinstalled], 0
		je	ds_exit
		cmp	[usesound], 0
		je	ds_exit

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

if Debug
		pushad
		mov	bx, bp
		mov	ah, [byte ptr PSGregs + bx]
		mov	al, bl
		mov	bx, [dbg_offs]
		mov	[word ptr dbg_buffer + bx], ax
		add	bx, 2
		cmp	bx, 2048
		jg	dsdbg_write
		mov	[dbg_offs], bx
		jmp	dsdbg_end
dsdbg_write:
		mov	[dbg_offs], 0
		mov	ax, 3d02h			; open file read/ write
		mov	dx, offset dbg_name
		int	21h
		jnc	dsdbg_exists
		mov	ax, 3c00h			; create file
		mov	cx, 0				; normal attributes
		mov	dx, offset dbg_name
		int	21h
dsdbg_exists:
		mov	bx, ax
		mov	ax, 4202h			; move file pointer to
		mov	cx, 0				; end of file
		mov	dx, 0
		int	21h

		mov	ax, 4000h			; write to file
		mov	cx, 2048
		mov	dx, offset dbg_buffer
		int	21h

		mov	ax, 3e00h			; close file
		int	21h
dsdbg_end:
		popad
endif

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

		cmp	bp, 13
		jg	short ds_exit

		cli
		pushad
		mov	si, offset jump_table
		mov	bx, bp
		shl	bx, 1
		mov	ax, [word ptr si + bx]
		jmp	ax
ds_exit:
		ret

; ________________________________________________________________________

calc_samples:
		mov	edx, [sound_freqval]		; sample rate / 62500
		mul	edx				;  * 65536 * 16
		shr	eax, 5
		mov	[dword ptr work_space], eax
		mov	bx, [word ptr work_space + 2]	; grab # of samples
		ret

; ________________________________________________________________________

AY_chanAfine:
AY_chanAcoarse:
		mov	ax, [word ptr PSGregs]
		and	eax, 0fffh			; mask out unused bits
		cmp	ax, [A_prevperiod]		; period changed?
		je	AY_cAexit
		mov	[A_prevperiod], ax
		call	calc_samples
		and	ah, 0f8h			; remove lower 3 bits
		mov	[byte ptr A_cntfrac], ah
		mov	[A_cntreload], bx		; counter reload value
AY_cAexit:
		jmp	sound_done

; ________________________________________________________________________

AY_chanBfine:
AY_chanBcoarse:
		mov	ax, [word ptr PSGregs + 2]
		and	eax, 0fffh			; mask out unused bits
		cmp	ax, [B_prevperiod]		; period changed?
		je	AY_cBexit
		mov	[B_prevperiod], ax
		call	calc_samples
		and	ah, 0f8h			; remove lower 3 bits
		mov	[byte ptr B_cntfrac], ah
		mov	[B_cntreload], bx		; counter reload value
AY_cBexit:
		jmp	sound_done

; ________________________________________________________________________

AY_chanCfine:
AY_chanCcoarse:
		mov	ax, [word ptr PSGregs + 4]
		and	eax, 0fffh			; mask out unused bits
		cmp	ax, [C_prevperiod]		; period changed?
		je	AY_cCexit
		mov	[C_prevperiod], ax
		call	calc_samples
		and	ah, 0f8h			; remove lower 3 bits
		mov	[byte ptr C_cntfrac], ah
		mov	[C_cntreload], bx		; counter reload value
AY_cCexit:
		jmp	sound_done

; ________________________________________________________________________

AY_noiseperiod:
		mov	al, [byte ptr PSGregs + 6]
		and	eax, 1fh
		cmp	ax, [noise_prevprd]		; period changed?
		je	AY_npexit
		mov	[noise_prevprd], ax
		call	calc_samples			; calculate counter
		and	ah, 0f8h			; remove lower 3 bits
		mov	[byte ptr noise_cntfrac], ah
		mov	[noise_cntreld], bx
AY_npexit:
		jmp	sound_done

; ________________________________________________________________________

AY_mixer:
		movzx	eax, [byte ptr PSGregs + 7]
		mov	[mixer_ctrl], ax
		jmp	sound_done

; ________________________________________________________________________

AY_chanAamplitude:
		movzx	bx, [byte ptr PSGregs + 8]
		cmp	bx, 16
		jb	AY_chAa_normal
		mov	al, 255
		jmp	AY_chAa_cont
AY_chAa_normal:
		mov	al, [byte ptr amp_table + bx]
AY_chAa_cont:
		mov	[byte ptr A_amplitude], al	; update amplitude
AY_chAa_exit:
		jmp	sound_done

; ________________________________________________________________________

AY_chanBamplitude:
		movzx	bx, [byte ptr PSGregs + 9]
		cmp	bx, 16
		jb	AY_chBa_normal
		mov	al, 255
		jmp	AY_chBa_cont
AY_chBa_normal:
		mov	al, [byte ptr amp_table + bx]
AY_chBa_cont:
		mov	[byte ptr B_amplitude], al	; update amplitude
AY_chBa_exit:
		jmp	sound_done

; ________________________________________________________________________

AY_chanCamplitude:
		movzx	bx, [byte ptr PSGregs + 10]
		cmp	bx, 16
		jb	AY_chCa_normal
		mov	al, 255
		jmp	AY_chCa_cont
AY_chCa_normal:
		mov	al, [byte ptr amp_table + bx]
AY_chCa_cont:
		mov	[byte ptr C_amplitude], al	; update amplitude
AY_chCa_exit:
		jmp	sound_done

; ________________________________________________________________________

calc_envsamples:
		mov	edx, [sound_freqval]		; sample rate / 3906.25
		mul	edx				;  * 65536
		jnc	ces_nooverflow
		mov	ax, dx				; get overflow
		ror	eax, 16				; swap hi / low word
		ret
ces_nooverflow:
		mov	[dword ptr work_space], eax
		mov	ax, [word ptr work_space + 2]	; grab frame length
		ret

; ________________________________________________________________________

AY_envfine:
AY_envcoarse:
		movzx	eax, [word ptr PSGregs + 11]
		or	ax, ax
		jnz	AY_epnotzero
		inc	ax
AY_epnotzero:
		cmp	ax, [env_prevperiod]		; change in period?
		je	AY_epexit
		mov	[env_prevperiod], ax

		call	calc_envsamples			; calculate counter

		mov	cx, ax
		mov	bl, al				; get fractional part
		shl	bl, 4				; change to x0h
		mov	[byte ptr env_fractional], bl
		mov	[byte ptr env_rf], bl
		shr	ax, 4				; divide by 16
		mov	[env_major], ax
		mov	[env_rm], ax
		or	ax, ax				; below 16?
		jnz	AY_epexit

		mov	ax, cx
		shl	ax, 4
		add	ax, offset env_inctable
		mov	[env_idtoffs], offset env_dectable - offset env_inctable
		test	[env_shape], 4			; x1xx ?
		jnz	AY_eppositive
		add	ax, [env_idtoffs]		; point to 2nd table
		neg	[env_idtoffs]			; decreasing ramp
AY_eppositive:
		mov	[env_idtorg], ax
		mov	[env_idtpos], ax
AY_epexit:
		jmp	sound_done

; ________________________________________________________________________

AY_envshape:
		mov	al, [byte ptr PSGregs + 13]
		and	ax, 0fh
		mov	[env_shape], ax

		test	ax, 4				; x1xx ?
		jnz	AY_esattack
		mov	al, [amp_table + 15]		; decreasing ramp..
		mov	[byte ptr env_value], al
		mov	[env_step], 16
		mov	[env_target], 0
		mov	[env_dir], -1
		jmp	AY_esexit
AY_esattack:
		mov	al, [amp_table]			; increasing ramp..
		mov	[byte ptr env_value], al
		mov	[env_step], -1
		mov	[env_target], 15
		mov	[env_dir], 1
AY_esexit:
		mov	[env_done], 0			; clear done flag

		jmp	sound_done

; ________________________________________________________________________

sound_done:
		popad
		sti
sound_return:
		ret

; ________________________________________________________________________

ends

segment	 _data page public 'DATA'

SC_shutdown	dw	sound_return
sound_pause	dw	sound_return
sound_continue	dw	sound_return
sound_clearINT	dw	sound_return
sound_freqval	dd	5a512h

curblockptr	dw	offset soundmem
soundmem_ptr	dw	offset soundmem
soundmem_end	dw	0
blocklen	dw	0
buffer_addr	dw	0
buffer_page	dw	0

DMA_addrport	db	0
DMA_countport	db	0
DMA_mode	db	0
DMA_pageport	db	0
DMA_startmask	db	0
DMA_stopmask	db	0

IRQ_oldoffset	dw	0
IRQ_oldsegment	dw	0
IRQ_intvector	db	0
IRQ_startmask	db	0
IRQ_stopmask	db	0

PIC_maskport	db	0

		even
noise_cnt	dw	0
noise_cntreld	dw	0
noise_cntfrac	dw	0
noise_cntrf	dw	0
noise_prevprd	dw	0
noise_value	dw	0

mixer_ctrl	dw	63

env_prevperiod	dw	0
env_major	dw	0
env_rm		dw	0
env_fractional	dw	0
env_rf		dw	0
env_idtorg	dw	offset amp_table
env_idtpos	dw	offset amp_table
env_idtoffs	dw	0
env_dir		dw	0
env_done	dw	1
env_shape	dw	0
env_step	dw	0
env_target	dw	0
env_value	dw	0

random_cnt	dw	0
random_val	dd	12345678h

work_space	dd	0

A_prevperiod	dw	0
A_cnt		dw	0
A_cntreload	dw	0
A_cntfrac	dw	0
A_cntrf		dw	0
A_value		dw	0
A_amplitude	dw	0

B_prevperiod	dw	0
B_cnt		dw	0
B_cntreload	dw	0
B_cntfrac	dw	0
B_cntrf		dw	0
B_value		dw	0
B_amplitude	dw	0

C_prevperiod	dw	0
C_cnt		dw	0
C_cntreload	dw	0
C_cntfrac	dw	0
C_cntrf		dw	0
C_value		dw	0
C_amplitude	dw	0

DMA_table	db	87h, 83h, 81h, 82h

amp_table	db	 0,  3,  4,  5,  7,  9, 11, 13
		db	17, 21, 26, 33, 41, 51, 64, 80

		even
env_inctable	db	15,XX, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		db	15,XX, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		db	 0,15,XX, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		db	 0, 8,15,XX, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		db	 0, 5,10,15,XX, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		db	 0, 4, 8,11,15,XX, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		db	 0, 3, 6, 9,12,15,XX, 0, 0, 0, 0, 0, 0, 0, 0, 0
		db	 0, 3, 5, 8,10,13,15,XX, 0, 0, 0, 0, 0, 0, 0, 0
		db	 0, 2, 4, 6, 9,11,13,15,XX, 0, 0, 0, 0, 0, 0, 0
		db	 0, 2, 4, 6, 8, 9,11,13,15,XX, 0, 0, 0, 0, 0, 0
		db	 0, 2, 3, 5, 7, 8,10,12,13,15,XX, 0, 0, 0, 0, 0
		db	 0, 2, 3, 5, 6, 8, 9,11,12,14,15,XX, 0, 0, 0, 0
		db	 0, 1, 3, 4, 5, 7, 8,10,11,12,14,15,XX, 0, 0, 0
		db	 0, 1, 3, 4, 5, 6, 8, 9,10,11,13,14,15,XX, 0, 0
		db	 0, 1, 2, 3, 5, 6, 7, 8, 9,10,12,13,14,15,XX, 0
		db	 0, 1, 2, 3, 4, 5, 6, 8, 9,10,11,12,13,14,15,XX

		even
env_dectable	db	15,XX, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		db	15,XX, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		db	15, 0,XX, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		db	15, 8, 0,XX, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		db	15,10, 5, 0,XX, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		db	15,11, 8, 4, 0,XX, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		db	15,12, 9, 6, 3, 0,XX, 0, 0, 0, 0, 0, 0, 0, 0, 0
		db	15,13,10, 8, 5, 3, 0,XX, 0, 0, 0, 0, 0, 0, 0, 0
		db	15,13,11, 9, 6, 4, 2, 0,XX, 0, 0, 0, 0, 0, 0, 0
		db	15,13,11, 9, 8, 6, 4, 2, 0,XX, 0, 0, 0, 0, 0, 0
		db	15,13,12,10, 8, 7, 5, 3, 2, 0,XX, 0, 0, 0, 0, 0
		db	15,14,12,11, 9, 8, 6, 5, 3, 2, 0,XX, 0, 0, 0, 0
		db	15,14,12,11,10, 8, 7, 5, 4, 3, 1, 0,XX, 0, 0, 0
		db	15,14,13,11,10, 9, 8, 6, 5, 4, 3, 1, 0,XX, 0, 0
		db	15,14,13,12,10, 9, 8, 7, 6, 5, 3, 2, 1, 0,XX, 0
		db	15,14,13,12,11,10, 9, 8, 6, 5, 4, 3, 2, 1, 0,XX

		even
jump_table	dw	AY_chanAfine
		dw	AY_chanAcoarse
		dw	AY_chanBfine
		dw	AY_chanBcoarse
		dw	AY_chanCfine
		dw	AY_chanCcoarse
		dw	AY_noiseperiod
		dw	AY_mixer
		dw	AY_chanAamplitude
		dw	AY_chanBamplitude
		dw	AY_chanCamplitude
		dw	AY_envfine
		dw	AY_envcoarse
		dw	AY_envshape

		even
SCcode_table	dw	SB_reset,SB_shutdown,SB_pause,SB_continue,SB_clrINT
		dw	GUS_reset,GUS_shutdown,GUS_pause,GUS_continue,GUS_clrINT
		dw	ESS_reset,ESS_shutdown,ESS_pause,ESS_continue,ESS_clrINT

		even
soundmem	db	1030 dup (0)

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

if Debug

dbg_handle	dw	0
dbg_offs	dw	0
dbg_name	db	'\psg.dat', 0

even
dbg_buffer	db	2048 dup (?)

endif

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

ends

; ________________________________________________________________________

segment	 _stack	para stack 'STACK'
ends

end

