; AY-3-8912 Programmable Sound Generator emulation for CPE
; Ensoniq Soundscape module
; Copyright (c) 1996,97 by Ulrich Doewich
; cyrel@interlog.com

;  v0.01       Oct. 30, 1996 - 00:05
;  v0.02       Oct. 31, 1996 - 22:33   completed ESS implementation
;  v0.03       Feb. 10, 1997 - 21:05   playback not started during init
;  v0.04       Mar. 24, 1997 - 16:53   pause & continue now check usesound

;  v1.00       Apr. 28, 1997 - 11:20   first public release

ideal
P386

ODIE           equ     0
OPUS           equ     1
MMIC           equ     2

CD_STATUS      equ     2
CD_FORMAT      equ     8
CD_CONFIG      equ     9
CD_PINCTL      equ     10
CD_UCOUNT      equ     14
CD_LCOUNT      equ     15

GA_HOSTCTL     equ     2
GA_ADDR        equ     4

GA_DMAB        equ     3
GA_INTCFG      equ     4
GA_DMACFG      equ     5
GA_CDCFG       equ     6

DMA_STATUSPORT equ     08h
DMA_MASKPORT   equ     0ah

; from ipe1.asm
extrn          SCinstalled:WORD, SCport:WORD, SCWport:WORD, SCMirq:WORD
extrn          SCirq:WORD, SCdma:WORD, DMAblocklen:WORD, SCsrate:WORD
extrn          stereo_flag:WORD, usesound:WORD

; from snd.asm
extrn          init_SC:PROC, setup_DMA:PROC, init_mixing:PROC
extrn          install_handler:PROC, uninstall_handler:PROC
extrn          DMA_stopmask:BYTE

public         ESS_reset, ESS_shutdown, ESS_pause, ESS_continue, ESS_clrINT

group          DGROUP _stack, _data

segment        _text page public 'CODE'
assume         cs:_text
assume         ds:DGROUP

; ________________________________________________________________________

; read_CD      read from the indirect addressed register in the CoDec

; IN:
;      al      indirect register number
; OUT:
;      al      corresponding contents

read_CD:
               mov     ah, al
               mov     dx, [SCWport]
               in      al, dx
               and     al, 0f0h                         ; keep special bits
               or      al, ah                           ; add register number
               out     dx, al
               inc     dx
               in      al, dx
               ret

; ________________________________________________________________________

; write_CD     write to the indirect addressed register in the CoDec

; IN:
;      al      indirect register number
;      bl      value to be written

write_CD:
               mov     ah, al
               mov     dx, [SCWport]
               in      al, dx
               and     al, 0f0h                         ; keep special bits
               or      al, ah                           ; add register number
               out     dx, al
               inc     dx
               mov     al, bl
               out     dx, al
               ret

; ________________________________________________________________________

; read_GA      read from the indirect addressed register in the Gate Array

; IN:
;      al      indirect register number
; OUT:
;      al      corresponding contents

read_GA:
               mov     dx, [SCport]
               add     dx, GA_ADDR
               out     dx, al
               inc     dx
               in      al, dx
               ret

; ________________________________________________________________________

; write_GA     write to the indirect addressed register in the Gate Array

; IN:
;      al      indirect register number
;      bl      value to be written

write_GA:
               mov     dx, [SCport]
               add     dx, GA_ADDR
               out     dx, al
               inc     dx
               mov     al, bl
               out     dx, al
               ret

; ________________________________________________________________________

start_CD:
               mov     dx, [SCWport]                    ; put CoDec in mode
               mov     al, 40h                          ;  change state
               out     dx, al
               mov     al, CD_FORMAT
               mov     bl, 07h                          ; 22kHz
               cmp     [SCsrate], 0
               je      sCD_22kHz
               mov     bl, 0bh                          ; 44kHz
sCD_22kHz:
               cmp     [stereo_flag], 0ffffh
               jne     sCD_skip
               or      bl, 10h                          ; stereo enabled
sCD_skip:
               call    write_CD
               mov     cx, 0                            ; give CoDec some time..
               mov     dx, [SCport]
               add     dx, GA_ADDR
sCD_waitloop:
               dec     cx
               jz      sCD_wldone
               in      al, dx
               jmp     sCD_waitloop
sCD_wldone:
               mov     bx, [DMAblocklen]
               cmp     [stereo_flag], 0ffffh
               jne     sCD_mono
               shr     bx, 1                            ; divide by two
sCD_mono:
               dec     bx
               mov     al, CD_LCOUNT                    ; pass DMA buffer length
               call    write_CD                         ;  to CoDec..
               mov     bl, bh
               mov     al, CD_UCOUNT
               call    write_CD

               call    setup_DMA                        ; setup DMA controller

               mov     dx, [SCWport]                    ; disable mode change
               mov     al, 0                            ;  state
               out     dx, al
               mov     al, CD_CONFIG
               call    read_CD
;               or      al, 1                            ; start playback
               and     al, 0fch                         ; disable playback
               mov     bl, al
               mov     al, CD_CONFIG
               call    write_CD
               ret

; ________________________________________________________________________

stop_CD:
               mov     al, CD_CONFIG
               call    read_CD
               and     al, 0fch                         ; stop playback
               mov     bl, al
               mov     al, CD_CONFIG
               call    write_CD

               mov     al, 10h
               mov     cx, [SCdma]
               rol     al, cl
               mov     bl, al
               mov     cl, 255                          ; wait for last DACKs..
sCD_loop:
               dec     cl
               jz      sCD_exit
               in      al, DMA_STATUSPORT
               and     al, bl
               jnz     sCD_loop
sCD_exit:
               ret

; ________________________________________________________________________

init_ESS:
               mov     dx, [SCport]                     ; check for Soundscape..
               add     dx, GA_HOSTCTL
               in      al, dx
               and     al, 78h
               jnz     iESS_error
               mov     dx, [SCport]
               add     dx, GA_ADDR
               in      al, dx
               and     al, 0f0h
               cmp     al, 0f0h
               je      iESS_error

               mov     al, 0f5h
               out     dx, al
               in      al, dx
               mov     ah, al
               and     al, 0f0h
               cmp     al, 0f0h
               je      iESS_error
               mov     al, ah
               and     al, 0fh
               cmp     al, 5
               jne     iESS_error

               mov     al, ah                           ; determine CoDec type..
               and     al, 80h
               jz      iESS_notMMIC
               mov     [CDtype], MMIC
               jmp     iESS_foundCD
iESS_notMMIC:
               mov     al, ah
               and     al, 70h
               jz      iESS_notOPUS
               mov     [CDtype], OPUS
               jmp     iESS_foundCD
iESS_notOPUS:
               mov     [CDtype], ODIE
iESS_foundCD:
               mov     dx, [SCWport]                    ; CoDec actually
               in      al, dx                           ;  present?
               and     al, 80h
               jnz     iESS_error

; ........................................................................

               call    stop_CD                          ; stop CoDec if running
               jnc     iESS_cont
iESS_error:
               mov     [SCinstalled], 0
               stc
               ret
iESS_cont:
               call    init_mixing                      ; setup DMA buffer

               mov     dx, [SCWport]                    ; clear pending INTs..
               add     dx, CD_STATUS
               mov     al, 0
               out     dx, al
               mov     dx, 22eh                         ; clear possible SB INTs
               in      al, dx

               call    init_SC                          ; setup IRQ/DMA vars
               call    install_handler                  ; install INT handler

               cmp     [CDtype], MMIC
               je      iESS_skip
               mov     si, offset ESS_irqs
               mov     ax, [SCMirq]
               mov     bx, 0
iESS_Mindxloop:
               cmp     al, [byte ptr si + bx]
               je      iESS_Mindxfound
               inc     bx
               cmp     bx, 4
               jb      iESS_Mindxloop
iESS_Mindxfound:
               mov     [Mindx], bl

               mov     si, offset ESS_irqs
               mov     ax, [SCirq]
               mov     bx, 0
iESS_Windxloop:
               cmp     al, [byte ptr si + bx]
               je      iESS_Windxfound
               inc     bx
               cmp     bx, 4
               jb      iESS_Windxloop
iESS_Windxfound:
               mov     [Windx], bl

               mov     al, GA_DMACFG                    ; set CoDec DMA polarity
               mov     bl, 50h
               call    write_GA

               mov     al, GA_CDCFG                     ; give CoDec cotrol over
               call    read_GA                          ;  DMA and IRQ..
               mov     [original_cfg], al
               mov     bx, [SCdma]
               rol     bl, 4
               mov     bh, [Windx]
               rol     bh, 1
               or      bl, bh
               or      bl, 89h
               mov     al, GA_CDCFG
               call    write_GA

               mov     al, GA_DMAB                      ; pull SB emulation off
               call    read_GA                          ;  those resources..
               mov     [original_dma], al
               mov     al, GA_DMAB
               mov     bl, 20h
               call    write_GA
               mov     al, GA_INTCFG
               call    read_GA
               mov     bl, [Mindx]
               rol     bl, 2
               or      bl, [Mindx]
               or      bl, 0f0h
               mov     al, GA_INTCFG
               call    write_GA
iESS_skip:
               mov     dx, [SCWport]                    ; put CoDec in mode
               mov     al, 40h                          ;  change state
               out     dx, al
               mov     al, CD_CONFIG
               mov     bl, 0ch                          ; set autocalibrate
               call    write_CD                         ;  & single DMA channel
               mov     al, CD_PINCTL
               call    read_CD
               or      al, 2                            ; enable INT pin
               mov     bl, al
               mov     al, CD_PINCTL
               call    write_CD
               ret

; ________________________________________________________________________

ESS_reset:
               call    init_ESS
               jc      ESSr_exit
               call    start_CD
ESSr_exit:
               ret

; ________________________________________________________________________

ESS_shutdown:
               cmp     [SCinstalled], 0
               je      ESSsd_exit

               call    stop_CD                          ; stop CoDec

               mov     al, CD_PINCTL
               call    read_CD
               and     al, 0fdh                         ; turn INT pin off
               mov     bl, al
               mov     al, CD_PINCTL
               call    write_CD

               cmp     [CDtype], MMIC
               je      ESSsd_skip
               mov     bl, [original_irq]               ; restore original
               mov     al, GA_INTCFG                    ;  settings..
               call    write_GA
               mov     bl, [original_dma]
               mov     al, GA_DMAB
               call    write_GA
               mov     bl, [original_cfg]
               mov     al, GA_CDCFG
               call    write_GA
ESSsd_skip:
               mov     dx, DMA_MASKPORT
               mov     al, [DMA_stopmask]
               out     dx, al                           ; stop DMA controller

               call    uninstall_handler
ESSsd_exit:
               ret

; ________________________________________________________________________

ESS_pause:
               cmp     [usesound], 0
               je      ESSp_exit

               pushad
               mov     al, CD_CONFIG
               call    read_CD
               and     al, 0fch                         ; disable playback
               mov     bl, al
               mov     al, CD_CONFIG
               call    write_CD
               popad
ESSp_exit:
               ret

; ________________________________________________________________________

ESS_continue:
               cmp     [usesound], 0
               je      ESSc_exit

               pushad
               mov     al, CD_CONFIG
               call    read_CD
               or      al, 1                            ; start playback
               mov     bl, al
               mov     al, CD_CONFIG
               call    write_CD
               popad
ESSc_exit:
               ret

; ________________________________________________________________________

ESS_clrINT:
               mov     dx, [SCWport]                    ; acknowledge interrupt
               add     dx, CD_STATUS                    ;  with ESS CoDec
               mov     al, 0
               out     dx, al
               ret

; ________________________________________________________________________

ends

segment        _data page public 'DATA'

CDtype         db      0
Mindx          db      0
Windx          db      0
original_cfg   db      0
original_irq   db      0
original_dma   db      0

ESS_irqs       db      9, 5, 7, 10

ends

; ________________________________________________________________________

segment        _stack para stack 'STACK'
ends

end

