/*
ͻ
 What's it called: EPMGCC  V3.20                                              
                                                                              
 What does it do:  The E source code for the GCC-Interface for EPM.           
                   This file contains the menu definitions and procedures.    
                                                                              
 Who and When:     B. Bablok 12/93 - 12/96                                    
                                                                              
ͼ
*/
TRYINCLUDE 'gccenv.e'
TRYINCLUDE 'gccconst.e'
/*
Ŀ
  DEFINIT: Initialize EPMGCC variables and post menu build                    

*/
DEFINIT
    UNIVERSAL gcc_project,            -- project name
              gcc_project_file,       -- make file name
              gcc_sel_projects,       -- previously selected projects
              gcc_d_comp_options,     -- compile options (debug)
              gcc_p_comp_options,     -- compile options (production)
              gcc_d_make_options,     -- make    options (debug)
              gcc_p_make_options,     -- make    options (production)
              gcc_error_file,         -- latest error-file
              gcc_error_file_id,      -- ID of latest error-file
              gcc_line2index,         -- ID of array
              gcc_index2err,          -- ID of array
              gcc_error_index,        -- index of current error
              gcc_debug,              -- debug mode
              gcc_autosave,           -- auto-save mode
              gcc_verbose,            -- verbose mode
              gcc_remove,             -- .err-remove mode
              gcc_runtime_arguments,  -- runtime arguments
              gcc_debug_arguments,    -- runtime arguments for debugger
              gcc_edit_cmd,           -- command to start makefile edit
              gcc_compile_cmd,        -- command to start compiler
              gcc_build_cmd,          -- command to start make
              gcc_debug_cmd,          -- command to start debug
              gcc_translate,          -- translate \ to / in filenames
              gcc_parser_mod,         -- current error-parser module
              gcc_save_settings       -- save settings to epm.ini

    UNIVERSAL app_hini

    gcc_project           = ''
    gcc_sel_projects      = QUERYPROFILE(app_hini,'GCC','GCC_SEL_PROJECTS')
    gcc_project_file      = ''
    gcc_error_file        = ''
    gcc_error_file_id     = ''
    gcc_line2index        = ''
    gcc_index2err         = ''
    gcc_error_index       = 0

    gcc_save_settings     = QUERYPROFILE(app_hini,'GCC','GCC_SETTINGS_MODE')
    if gcc_save_settings = 1 then    -- settings were saved the last time

       gcc_debug             = QUERYPROFILE(app_hini,'GCC','GCC_DEBUG_MODE')
       gcc_autosave          = QUERYPROFILE(app_hini,'GCC','GCC_AUTOSAVE_FILE')
       gcc_verbose           = QUERYPROFILE(app_hini,'GCC','GCC_VERBOSE_MODE')
       gcc_remove            = QUERYPROFILE(app_hini,'GCC','GCC_REMOVE_MODE')

       gcc_d_comp_options    = QUERYPROFILE(app_hini,'GCC','GCC_D_COMPILE_OPTIONS')
       gcc_p_comp_options    = QUERYPROFILE(app_hini,'GCC','GCC_P_COMPILE_OPTIONS')
       gcc_d_make_options    = QUERYPROFILE(app_hini,'GCC','GCC_D_BUILD_OPTIONS')
       gcc_p_make_options    = QUERYPROFILE(app_hini,'GCC','GCC_P_BUILD_OPTIONS')

       gcc_edit_cmd          = QUERYPROFILE(app_hini,'GCC','GCC_EDIT_COMMAND')
       gcc_compile_cmd       = QUERYPROFILE(app_hini,'GCC','GCC_COMP_COMMAND')
       gcc_build_cmd         = QUERYPROFILE(app_hini,'GCC','GCC_BUILD_COMMAND')
       gcc_debug_cmd         = QUERYPROFILE(app_hini,'GCC','GCC_DEBUG_COMMAND')
       gcc_translate         = QUERYPROFILE(app_hini,'GCC','GCC_WANT_TRANSLATE')
       gcc_parser_mod        = QUERYPROFILE(app_hini,'GCC','GCC_PARSER_MODULE')

       gcc_runtime_arguments = QUERYPROFILE(app_hini,'GCC','GCC_RT_ARGS')
       gcc_debug_arguments   = QUERYPROFILE(app_hini,'GCC','GCC_DB_ARGS')

    else

       gcc_debug             = GCC_DEBUG_MODE
       gcc_autosave          = GCC_AUTOSAVE_FILE
       gcc_verbose           = GCC_VERBOSE_MODE
       gcc_remove            = GCC_REMOVE_MODE
       gcc_save_settings     = GCC_SETTINGS_MODE

       gcc_d_comp_options    = GCC_D_COMPILE_OPTIONS
       gcc_p_comp_options    = GCC_P_COMPILE_OPTIONS
       gcc_d_make_options    = GCC_D_BUILD_OPTIONS
       gcc_p_make_options    = GCC_P_BUILD_OPTIONS

       gcc_edit_cmd          = GCC_EDIT_COMMAND
       gcc_compile_cmd       = GCC_COMP_COMMAND
       gcc_build_cmd         = GCC_BUILD_COMMAND
       gcc_debug_cmd         = GCC_DEBUG_COMMAND
       gcc_translate         = GCC_WANT_TRANSLATE
       gcc_parser_mod        = GCC_PARSER_MODULE

       gcc_runtime_arguments = ''
       gcc_debug_arguments   = ''
    endif

    'PostMe BuildGCCMenu'
    'PostMe LINK' gcc_parser_mod
    'PostMe SAYERROR Current parser module:' gcc_parser_mod
/*
Ŀ
  DEFEXIT: Save EPMGCC variables if necessary                                 

*/
DEFEXIT
    UNIVERSAL gcc_sel_projects,       -- previously selected projects
              gcc_d_comp_options,     -- compile options (debug)
              gcc_p_comp_options,     -- compile options (production)
              gcc_d_make_options,     -- make    options (debug)
              gcc_p_make_options,     -- make    options (production)
              gcc_debug,              -- debug mode
              gcc_autosave,           -- auto-save mode
              gcc_verbose,            -- verbose mode
              gcc_remove,             -- .err-remove mode
              gcc_runtime_arguments,  -- runtime arguments
              gcc_debug_arguments,    -- runtime arguments for debugger
              gcc_edit_cmd,           -- command to start makefile edit
              gcc_compile_cmd,        -- command to start compiler
              gcc_build_cmd,          -- command to start make
              gcc_debug_cmd,          -- command to start debug
              gcc_translate,          -- translate \ to / in filenames
              gcc_parser_mod,         -- current error-parser module
              gcc_save_settings       -- save settings to epm.ini

    UNIVERSAL app_hini

    CALL SETPROFILE(app_hini,'GCC','GCC_SEL_PROJECTS',gcc_sel_projects)
    CALL SETPROFILE(app_hini,'GCC','GCC_SETTINGS_MODE',gcc_save_settings)

    if gcc_save_settings = 1 then

       CALL SETPROFILE(app_hini,'GCC','GCC_DEBUG_MODE',gcc_debug)
       CALL SETPROFILE(app_hini,'GCC','GCC_AUTOSAVE_FILE',gcc_autosave)
       CALL SETPROFILE(app_hini,'GCC','GCC_VERBOSE_MODE',gcc_verbose)
       CALL SETPROFILE(app_hini,'GCC','GCC_REMOVE_MODE',gcc_remove)

       CALL SETPROFILE(app_hini,'GCC','GCC_D_COMPILE_OPTIONS',gcc_d_comp_options)
       CALL SETPROFILE(app_hini,'GCC','GCC_P_COMPILE_OPTIONS',gcc_p_comp_options)
       CALL SETPROFILE(app_hini,'GCC','GCC_D_BUILD_OPTIONS',gcc_d_make_options)
       CALL SETPROFILE(app_hini,'GCC','GCC_P_BUILD_OPTIONS',gcc_p_make_options)

       CALL SETPROFILE(app_hini,'GCC','GCC_EDIT_COMMAND',gcc_edit_cmd)
       CALL SETPROFILE(app_hini,'GCC','GCC_COMP_COMMAND',gcc_compile_cmd)
       CALL SETPROFILE(app_hini,'GCC','GCC_BUILD_COMMAND',gcc_build_cmd)
       CALL SETPROFILE(app_hini,'GCC','GCC_DEBUG_COMMAND',gcc_debug_cmd)
       CALL SETPROFILE(app_hini,'GCC','GCC_WANT_TRANSLATE',gcc_translate)
       CALL SETPROFILE(app_hini,'GCC','GCC_PARSER_MODULE',gcc_parser_mod)

       CALL SETPROFILE(app_hini,'GCC','GCC_RT_ARGS',gcc_runtime_arguments)
       CALL SETPROFILE(app_hini,'GCC','GCC_DB_ARGS',gcc_debug_arguments)

    endif
/*
Ŀ
  GCC menu registering                                                        

*/
DEFSELECT
   'PostMe GCCMenuEnable'

DEFLOAD
   'PostMe GCCMenuEnable'
/*
Ŀ
  Define GCC menu system                                                       

*/
DEFC BuildGCCMenu =
    UNIVERSAL defaultmenu, activemenu

    DELETEMENU defaultmenu, HELP_MENU_ID, 0, 0      -- delete help menu

    BUILDSUBMENU defaultmenu, 21, '~GCC', GCC_MENU__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2101, '~Open Project',
                               'gcc_open_project'GCC_OPEN__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2118, '~Select Project',
                               'gcc_select_project'GCC_SEL__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2102, '~Edit Project',
                               'gcc_edit_project'GCC_EDIT__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2103, 'C~lose Project',
                               'gcc_close_project'GCC_CLOSE__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2104, \0, '', 4, 0
    BUILDMENUITEM defaultmenu, 21, 2105, 'Set com~pile options  c-F11',
                               'gcc_set_comp_options'GCC_COMP_OPT__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2106, '~Compile current file  c-F12',
                               'gcc_compile_file'GCC_COMP__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2107, 'Set b~uild options     s-F11',
                               'gcc_set_make_options'GCC_BUILD_OPT__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2108, '~Build current project s-F12',
                               'gcc_build_project'GCC_BUILD__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2109, '~View results',
                               'gcc_view_results'GCC_VIEW__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2100, \0, '', 4, 0
    BUILDMENUITEM defaultmenu, 21, 2111, '~Run Exe',
                               'gcc_run_exe'GCC_RUN__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2112, '~Debug Exe',
                               'gcc_debug_exe'GCC_DEBUG__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2113, \0, '', 4, 0
    BUILDMENUITEM defaultmenu, 21, 2114, 'Debug ~Mode',
                               'gcc_toggle_debug_mode'GCC_DEBUGMODE__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2115, '~Auto Save',
                               'gcc_toggle_autosave_mode'GCC_AUTOSAVE__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2116, 'Verbose (~test) Mode',
                               'gcc_toggle_verbose_mode'GCC_VERBOSE__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2117, 'Remove ~.err-files automatically',
                               'gcc_toggle_remove_mode'GCC_REMOVE__MSG, 0,0
    BUILDMENUITEM defaultmenu, 21, 2119, 'Save settings',
                               'gcc_toggle_settings_mode'GCC_SETTINGS__MSG, 0,0

    CALL READD_HELP_MENU()
    -- SHOWMENU defaultmenu
    call maybe_show_menu()
    'PostMe  GCCMenuEnable'

-- enable the GCC menu only if a c/cc/h-, error- or make-file is loaded -
-- or if GCC_MENU_ALWAYS_ON is set

DEFC GCCMenuEnable =
 COMPILE IF GCC_MENU_ALWAYS_ON = 1
    gcc_enabled = 1
 COMPILE ELSE
    ext = FILETYPE()
    gcc_enabled = WORDPOS(ext,GCC_EXTENSIONS) > 0
 COMPILE ENDIF
 SetMenuAttribute(21, 16384, gcc_enabled)
 RETURN

/*
Ŀ
  Command definitions (menu commands)                                         

*/
DEFC gcc_open_project =
  UNIVERSAL gcc_project_file, gcc_project, gcc_error_file, gcc_error_file_id,
            gcc_sel_projects

  IF ARG(1) <> '' THEN
     gcc_project_file = ARG(1)     -- called from gcc_select_project
  ELSE
     gcc_project_file = ENTRYBOX('Make-file name:','/Ok/Cancel/',
                                                         gcc_project_file,20,40)
     IF gcc_project_file = '' THEN
        RETURN
     ELSE
        CALL gcc_delete_arrays()
     ENDIF
  ENDIF

  IF POS('.',gcc_project_file) > 0 THEN
     gcc_project = SUBSTR(gcc_project_file,1,LASTPOS('.',gcc_project_file)-1)
  ELSE
     gcc_project = gcc_project_file
  ENDIF

  gcc_error_file    = ''
  gcc_error_file_id = ''

  IF ARG(1) = '' THEN
     IF POS(LOWCASE(gcc_project_file),LOWCASE(gcc_sel_projects)) = 0 THEN
        IF gcc_sel_projects = '' THEN
           gcc_sel_projects = '/' || gcc_project_file || '/'
        ELSEIF COUNT('/',gcc_sel_projects) < 6 THEN
              gcc_sel_projects = '/' || gcc_project_file || gcc_sel_projects
        ELSE
           gcc_sel_projects = STRIP(gcc_sel_projects,'T','/')
           gcc_sel_projects = '/' || gcc_project_file ||
                       SUBSTR(gcc_sel_projects,1, LASTPOS('/',gcc_sel_projects))
        ENDIF
     ELSE
        CALL gcc_reorder_projects(gcc_project_file)
     ENDIF
  ENDIF

DEFC gcc_select_project =
   UNIVERSAL gcc_sel_projects

   IF gcc_sel_projects = '' THEN
      SAYERROR 'Selection list is empty. Use "Open project"'
   ELSE
      selected = LISTBOX('Select project',gcc_sel_projects,'/OK/Cancel',5,35)
      IF selected <> '' THEN
         'gcc_close_project'
         'gcc_open_project' selected
         CALL gcc_reorder_projects(selected)
      ELSE
         SAYERROR 'Select canceled'
      ENDIF
   ENDIF

DEFC gcc_edit_project =
  UNIVERSAL gcc_project_file, gcc_edit_cmd
  gcc_edit_cmd gcc_project_file

DEFC gcc_close_project =
  UNIVERSAL gcc_project, gcc_project_file, gcc_error_file, gcc_error_file_id
  gcc_project       = ''
  gcc_project_file  = ''
  gcc_error_file    = ''
  gcc_error_file_id = ''
  CALL gcc_delete_arrays()

DEFC gcc_set_comp_options =
  UNIVERSAL gcc_d_comp_options, gcc_p_comp_options, gcc_debug

  IF gcc_debug THEN
    buf = ENTRYBOX('Compile parameters (debug):','/Ok/CANCEL/',
                                              gcc_d_comp_options,30,100,atoi(1))
  ELSE
    buf = ENTRYBOX('Compile parameters (prod):','/Ok/CANCEL/',
                                              gcc_p_comp_options,30,100,atoi(1))
  ENDIF
  button = ASC(SUBSTR(buf,1,1))
  IF button <> 1 THEN
     SAYERROR 'Cancelled'
  ELSE
     eos = POS(\0,buf,2)
     IF gcc_debug THEN
        gcc_d_comp_options = SUBSTR(buf,2,eos-2)
     ELSE
        gcc_p_comp_options = SUBSTR(buf,2,eos-2)
     ENDIF
  ENDIF

DEFC gcc_compile_file =
  UNIVERSAL gcc_error_file, gcc_error_file_id, gcc_autosave, gcc_verbose,
            gcc_debug, gcc_d_comp_options, gcc_p_comp_options, gcc_remove,
            gcc_compile_cmd, gcc_line2index, gcc_index2err, gcc_error_index

  IF .modify THEN
     IF gcc_autosave THEN
        'Save'
         SAYERROR 'Saving file before invoking' WORD(gcc_compile_cmd,
                                                     WORDS(gcc_compile_cmd))'!'
     ELSE
         SAYERROR 'Warning: File not saved! Compiling old version!'
     ENDIF
  ENDIF

  IF gcc_remove THEN
     GETFILEID StartFileID
     LOOP
        IF gcc_remove AND FILETYPE() = 'ERR' THEN
           IF .modify THEN
              'FILE'
           ELSE
              'QUIT'
           ENDIF
        ENDIF
        NEXTFILE
        GETFILEID NextFileID
        IF NextFileID = StartFileID THEN
           LEAVE
        ENDIF
        ACTIVATEFILE NextFileID
     ENDLOOP
     ACTIVATEFILE StartFileID
  ENDIF

  gcc_error_file = SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'err'

  IF gcc_debug THEN
     arguments = gcc_resolve_template(gcc_d_comp_options,'C')
  ELSE
     arguments = gcc_resolve_template(gcc_p_comp_options,'C')
  ENDIF

  IF gcc_verbose THEN
     SAYERROR '(' || gcc_compile_cmd arguments || ') > ' || gcc_error_file '2>&1'
  ENDIF

  '(' || gcc_compile_cmd arguments || ') > ' || gcc_error_file '2>&1'
  IF rc <> 0 THEN
     SAYERROR 'Error invoking' WORD(gcc_compile_cmd,
                                             WORDS(gcc_compile_cmd))', RC =' rc
  ELSE
     gcc_error_file_id = ''                   -- reset error_file_id
     CALL gcc_delete_arrays()
  ENDIF

DEFC gcc_set_make_options =
  UNIVERSAL gcc_d_make_options, gcc_p_make_options, gcc_debug

  IF gcc_debug THEN
    buf = ENTRYBOX('Build parameters (debug):','/Ok/CANCEL/',
                                              gcc_d_make_options,30,100,atoi(1))
  ELSE
    buf = ENTRYBOX('Build parameters (prod):','/Ok/CANCEL/',
                                              gcc_p_make_options,30,100,atoi(1))
  ENDIF
  button = ASC(SUBSTR(buf,1,1))
  IF button <> 1 THEN
     SAYERROR 'Cancelled'
  ELSE
     eos = POS(\0,buf,2)
     IF gcc_debug THEN
        gcc_d_make_options = SUBSTR(buf,2,eos-2)
     ELSE
        gcc_p_make_options = SUBSTR(buf,2,eos-2)
     ENDIF
  ENDIF

DEFC gcc_build_project =
  UNIVERSAL gcc_error_file, gcc_project_file, gcc_project, gcc_verbose,
            gcc_debug, gcc_error_file_id, gcc_d_make_options,
            gcc_p_make_options, gcc_autosave, gcc_remove, gcc_build_cmd,
            gcc_line2index, gcc_index2err, gcc_error_index

  IF gcc_autosave OR gcc_remove THEN
     IF gcc_autosave THEN
        SAYERROR 'Checking for modified files ...'
     ENDIF
     GETFILEID StartFileID
     NextFileID = ''
     LOOP
        IF gcc_remove AND FILETYPE() = 'ERR' THEN
           IF .modify THEN
              'FILE'
           ELSE
              'QUIT'
           ENDIF
           IF NextFileID = '' THEN
              GETFILEID StartFileID
              ITERATE
           ENDIF
        ELSEIF gcc_autosave AND .modify THEN
           'Save'
        ENDIF
        NEXTFILE
        GETFILEID NextFileID
        IF NextFileID = StartFileID THEN
           LEAVE
        ENDIF
        ACTIVATEFILE NextFileID
     ENDLOOP
     ACTIVATEFILE StartFileID
  ENDIF

  gcc_error_file = gcc_project || '.err' -- intervening compile_file is possible
  IF gcc_debug THEN
     arguments = gcc_resolve_template(gcc_d_make_options,'M')
  ELSE
     arguments = gcc_resolve_template(gcc_p_make_options,'M')
  ENDIF

  IF gcc_verbose THEN
     SAYERROR '(' || gcc_build_cmd arguments  || ') > ' || gcc_error_file '2>&1'
  ENDIF

  '(' || gcc_build_cmd arguments || ') > ' || gcc_error_file '2>&1'
  IF rc <> 0 THEN
     SAYERROR 'Error invoking' WORD(gcc_build_cmd,
                                             WORDS(gcc_build_cmd))', RC =' rc
  ELSE
     gcc_error_file_id = ''                   -- reset error_file_id
     CALL gcc_delete_arrays()
  ENDIF

DEFC gcc_view_results =
  UNIVERSAL gcc_project, gcc_error_file, gcc_error_file_id,
            gcc_line2index, gcc_index2err, gcc_error_index


  IF gcc_error_file_id <> '' THEN
     'EDIT' gcc_error_file
  ELSE
     IF gcc_error_file <> '' THEN
        'EDIT /d' gcc_error_file
     ELSEIF EXIST(gcc_project'.err') THEN
        gcc_error_file = gcc_project'.err'
        'EDIT /d' gcc_error_file
     ELSEIF EXIST(SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'err') THEN
        gcc_error_file = SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'err'
        'EDIT /d' gcc_error_file
     ENDIF
     GETFILEID gcc_error_file_id
  ENDIF
  IF gcc_index2err <> '' THEN
     DO_ARRAY 7, gcc_index2err, 'orig.'gcc_error_index, line
     .line = line
  ENDIF

DEFC gcc_run_exe =
  UNIVERSAL gcc_project, gcc_runtime_arguments, gcc_compile_cmd, gcc_verbose

  IF POS(TRANSLATE(LASTWORD(gcc_compile_cmd)),'JAVAC NRC') > 0 THEN
     gcc_javapgm = LISTBOX('Select program:','/java/javapm/applet','/OK/Cancel',5,35)
     IF gcc_javapgm = '' THEN
        SAYERROR 'Cancelled'
        RETURN
     ENDIF
  ENDIF

  buf = ENTRYBOX('Programm parameters:','/Ok/CANCEL/',gcc_runtime_arguments,
                                                                  30,60,atoi(1))
  button = ASC(SUBSTR(buf,1,1))
  IF button <> 1 THEN
     SAYERROR 'Cancelled'
     RETURN
  ELSE
     eos = POS(\0,buf,2)
     gcc_runtime_arguments = SUBSTR(buf,2,eos-2)
     IF POS(TRANSLATE(LASTWORD(gcc_compile_cmd)),'JAVAC NRC') = 0 THEN
        IF EXIST(gcc_project'.exe') THEN
           IF gcc_verbose THEN
              SAYERROR 'start /n /f'  gcc_project gcc_runtime_arguments
           ENDIF
           'start /n /f'  gcc_project gcc_runtime_arguments
        ELSE
           IF gcc_verbose THEN
              SAYERROR 'start /n /f'
                         SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'exe ' ||
                                                           gcc_runtime_arguments
           ENDIF
           'start /n /f' SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'exe ' ||
                                                          gcc_runtime_arguments
        ENDIF
     ELSEIF gcc_javapgm = 'applet' THEN
        IF EXIST(gcc_runtime_arguments) THEN
           IF gcc_verbose THEN
              SAYERROR 'start /n /f applet' gcc_runtime_arguments
           ENDIF
           'start /n /f applet' gcc_runtime_arguments
        ELSE
           SAYERROR gcc_runtime_arguments 'not found'
           RETURN
        ENDIF
     ELSE
        IF EXIST(gcc_project'.class') THEN
           run_class = SUBSTR(gcc_project,LASTPOS('\',gcc_project)+1)
        ELSEIF EXIST(SUBSTR(.filename,1,LASTPOS('.',.filename))'class') THEN
           run_class = SUBSTR(.filename,LASTPOS('\',.filename)+1)
           run_class = SUBSTR(run_class,1,LASTPOS('.',run_class)-1)
        ELSE
           SAYERROR 'Class not found'
           RETURN
        ENDIF
        IF gcc_verbose THEN
           SAYERROR 'start /n /f' gcc_javapgm  run_class gcc_runtime_arguments
        ENDIF
        'start /n /f' gcc_javapgm  run_class gcc_runtime_arguments
     ENDIF
  ENDIF

DEFC gcc_debug_exe =
  UNIVERSAL gcc_project, gcc_debug_cmd, gcc_translate, gcc_debug_arguments

  buf = ENTRYBOX('Programm parameters:','/Ok/CANCEL/',gcc_debug_arguments,
                                                                  30,60,atoi(1))
  button = ASC(SUBSTR(buf,1,1))
  IF button <> 1 THEN
     SAYERROR 'Cancelled'
  ELSE
     eos = POS(\0,buf,2)
     gcc_debug_arguments = SUBSTR(buf,2,eos-2)
     IF EXIST(gcc_project'.exe') THEN
        IF gcc_translate THEN
           gcc_debug_cmd TRANSLATE(gcc_project||'.exe','/','\') ||
                                                           gcc_debug_arguments
        ELSE
           gcc_debug_cmd gcc_project||'.exe' gcc_debug_arguments
        ENDIF
     ELSE
        IF gcc_translate THEN
           gcc_debug_cmd TRANSLATE(SUBSTR(.filename,1,LASTPOS('.',.filename))||
                                            'exe','/','\') gcc_debug_arguments
        ELSE
           gcc_debug_cmd SUBSTR(.filename,1,LASTPOS('.',.filename))|| 'exe ' ||
                                                           gcc_debug_arguments
        ENDIF
     ENDIF
  ENDIF

DEFC gcc_toggle_debug_mode =
  UNIVERSAL gcc_debug, gcc_verbose
  gcc_debug = NOT gcc_debug
  IF gcc_verbose THEN
     IF gcc_debug THEN
        SAYERROR 'Debug mode = ON'
     ELSE
        SAYERROR 'Debug mode = OFF'
     ENDIF
  ENDIF

DEFC gcc_toggle_autosave_mode =
  UNIVERSAL gcc_autosave, gcc_verbose
  gcc_autosave = NOT gcc_autosave
  IF gcc_verbose THEN
     IF gcc_autosave THEN
        SAYERROR 'Autosave mode = ON'
     ELSE
        SAYERROR 'Autosave mode = OFF'
     ENDIF
  ENDIF

DEFC gcc_toggle_verbose_mode =
  UNIVERSAL gcc_verbose
  gcc_verbose = NOT gcc_verbose
  IF gcc_verbose THEN
     SAYERROR 'Verbose mode = ON'
  ELSE
     SAYERROR 'Verbose mode = OFF'
  ENDIF

DEFC gcc_toggle_remove_mode =
  UNIVERSAL gcc_remove, gcc_verbose
  gcc_remove = NOT gcc_remove
  IF gcc_verbose THEN
     IF gcc_remove THEN
        SAYERROR 'Remove mode = ON'
     ELSE
        SAYERROR 'Remove mode = OFF'
     ENDIF
  ENDIF

DEFC gcc_toggle_settings_mode =
  UNIVERSAL gcc_save_settings, gcc_verbose
  gcc_save_settings = NOT gcc_save_settings
  IF gcc_verbose THEN
     IF gcc_save_settings THEN
        SAYERROR 'Save settings mode = ON'
     ELSE
        SAYERROR 'Save settings mode = OFF'
     ENDIF
  ENDIF

DEFC gcc_setpos =
  .line = WORD(ARG(1),1)
  .col  = WORD(ARG(1),2)
  IF WORDS(ARG(1)) = 3 THEN
     CIRCLEIT 3, .line, .col, .col-1+WORD(ARG(1),3), 16777220, 16777218
  ENDIF

/*
Ŀ
  Definition of commands used from menubar/commandline                        

*/

DEFC gcc_prev_err =
   UNIVERSAL gcc_error_file_id, gcc_error_file,
             gcc_line2index, gcc_index2err, gcc_error_index

   IF gcc_line2index = '' THEN                  -- arrays not initialized
      IF gcc_error_file_exists() THEN
         IF gcc_create_error_index() <> 0 THEN
            RETURN
         ENDIF
      ELSE
         SAYERROR 'No compile/build-results available. Use Compile/Build first.'
         RETURN
      ENDIF
   ENDIF

   /* if in error-file, look for previous error-line */

   GETFILEID this_file_id
   IF this_file_id = gcc_error_file_id THEN       -- in error-file
      n = ''
      is_error_line = 1
      WHILE (.line > 0) DO
         do_array 7, gcc_line2index, .line, n
         IF n <> '' THEN
            IF is_error_line THEN
               gcc_error_index = n
            ELSE
               gcc_error_index = n + 1
            ENDIF
            LEAVE
         ELSEIF .line = 1 THEN
            SAYERROR "No previous error!"
            RETURN
         ELSE                           -- try previous line
           .line = .line - 1
         ENDIF
      ENDWHILE
   ENDIF

   /* decrement error-index and lookup error */

   IF gcc_error_index < 2 THEN
      SAYERROR "No previous error!"
   ELSE
      gcc_error_index = gcc_error_index - 1
      CALL gcc_display_error()
   ENDIF


DEFC gcc_curr_err =
   UNIVERSAL gcc_error_file_id, gcc_error_file,
             gcc_line2index, gcc_index2err, gcc_error_index

   IF gcc_line2index = '' THEN
      IF gcc_error_file_exists() THEN
         IF gcc_create_error_index() <> 0 THEN
            RETURN
         ENDIF
      ELSE
         SAYERROR 'No compile/build-results available. Use Compile/Build first.'
         RETURN
      ENDIF
   ENDIF

   /* if in error-file, check for error-line */

   GETFILEID this_file_id
   IF this_file_id = gcc_error_file_id THEN       -- in error-file
      n = ''
      do_array 7, gcc_line2index, .line, n
      IF n <> '' THEN
         gcc_error_index = n
      ELSE
         'gcc_next_err'
         RETURN
      ENDIF
   ENDIF
   CALL gcc_display_error()


DEFC gcc_next_err =
   UNIVERSAL gcc_error_file_id, gcc_error_file,
             gcc_line2index, gcc_index2err, gcc_error_index

   IF gcc_line2index = '' THEN
      IF gcc_error_file_exists() THEN
         IF gcc_create_error_index() <> 0 THEN
            RETURN
         ELSE
            gcc_error_index = 0    -- first time after compile/build:
         ENDIF                     -- next_err == curr_err == first error
      ELSE
         SAYERROR 'No compile/build-results available. Use Compile/Build first.'
         RETURN
      ENDIF
   ENDIF

   /* if in error-file, look for next error-line */

   GETFILEID this_file_id
   IF this_file_id = gcc_error_file_id THEN       -- in error-file
      n = ''
      is_error_line = 1
      WHILE (.line <= .last) DO
         do_array 7, gcc_line2index, .line, n
         IF n <> '' THEN
            IF is_error_line THEN
               gcc_error_index = n
            ELSE
               gcc_error_index = n - 1
            ENDIF
            LEAVE
         ELSEIF .line = .last THEN
            SAYERROR "No more errors!"
            RETURN
         ELSE                           -- try the next line
           is_error_line = 0
           "+1"
         ENDIF
      ENDWHILE
   ENDIF

   /* increment error-index and lookup error */

   do_array 7, gcc_index2err, 0, limit
   IF gcc_error_index = limit THEN
      SAYERROR "No more errors!"
   ELSE
      gcc_error_index = gcc_error_index + 1
      CALL gcc_display_error()
   ENDIF

/*
Ŀ
  Procedure definitions                                                       

*/

DEFPROC gcc_reorder_projects =
  UNIVERSAL gcc_sel_projects

  file = ARG(1)
  gcc_sel_projects = '/'file || DELSTR(gcc_sel_projects,
                                POS(LOWCASE(file'/'),LOWCASE(gcc_sel_projects)),
                                                                LENGTH(file'/'))

DEFPROC get_gcc_debug_mode =
  UNIVERSAL gcc_debug
  RETURN gcc_debug

DEFPROC get_gcc_autosave_mode =
  UNIVERSAL gcc_autosave
  RETURN gcc_autosave

DEFPROC get_gcc_verbose_mode =
  UNIVERSAL gcc_verbose
  RETURN gcc_verbose

DEFPROC get_gcc_remove_mode =
  UNIVERSAL gcc_remove
  RETURN gcc_remove

DEFPROC get_gcc_settings_mode =
  UNIVERSAL gcc_save_settings
  RETURN gcc_save_settings

DEFPROC gcc_project_open =
  UNIVERSAL gcc_project
  RETURN gcc_project <> ''

DEFPROC gcc_project_file_exists =
  UNIVERSAL gcc_project_file
  RETURN EXIST(gcc_project_file)

DEFPROC gcc_exe_exists =
  UNIVERSAL gcc_project, gcc_compile_cmd
  IF POS(TRANSLATE(LASTWORD(gcc_compile_cmd)),'JAVAC NRC') = 0 THEN
     RETURN EXIST(gcc_project || '.exe') OR
            EXIST(SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'exe')
  ELSE
     RETURN EXIST(gcc_project || '.class') OR
            EXIST(SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'class')
  ENDIF

DEFPROC gcc_error_file_exists =
  UNIVERSAL gcc_project, gcc_error_file
  RETURN gcc_error_file <> '' OR  EXIST(gcc_project || '.err') OR
         EXIST(SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'err')

DEFPROC gcc_is_cc_file =
  ext = FILETYPE()
  RETURN WORDPOS(ext,GCC_EXTENSIONS) > 0

DEFPROC gcc_next_error =
   UNIVERSAL gcc_error_file_id, gcc_other_file_id, gcc_error_file

   IF gcc_error_file_id = '' THEN
      IF gcc_error_file_exists() THEN
         'gcc_view_results'
      ELSE
         SAYERROR 'No compile/build-results available. Use Compile/Build first.'
      ENDIF
      RETURN
   ENDIF

   GETFILEID gcc_other_file_id
   IF gcc_other_file_id <> gcc_error_file_id THEN      -- not in error-file
     'gcc_next_err'
   ELSE
     'gcc_curr_err'
   ENDIF

DEFPROC gcc_resolve_template =
   UNIVERSAL gcc_project_file, gcc_translate

   template = ARG(1)
   option   = ARG(2)    -- C for compile and M for make

   IF option = 'C' THEN
      file = .filename
   ELSE
      file = gcc_project_file
   ENDIF
   path = SUBSTR(file,1,LASTPOS('\',file))
   IF SUBSTR(file,2,1) = ':' THEN
       drive = SUBSTR(file,1,2)
   ELSE
       drive = ''
   ENDIF
   fname = DELSTR(file,1,LENGTH(path))
   name  = SUBSTR(fname,1,LASTPOS('.',fname)-1)
   ext   = DELSTR(fname,1,LENGTH(name)+1)

   col = POS('%**E',template)
   WHILE col > 0 DO
      template = DELSTR(template,col,4)
      template = SUBSTR(template,1,col-1) || ext || SUBSTR(template,col)
      col = POS('%**E',template)
   ENDWHILE
   col = POS('%**N',template)
   WHILE col > 0 DO
      template = DELSTR(template,col,4)
      template = SUBSTR(template,1,col-1) || name || SUBSTR(template,col)
      col = POS('%**N',template)
   ENDWHILE
   col = POS('%**F',template)
   WHILE col > 0 DO
      template = DELSTR(template,col,4)
      template = SUBSTR(template,1,col-1) || fname || SUBSTR(template,col)
      col = POS('%**F',template)
   ENDWHILE
   col = POS('%**P',template)
   WHILE col > 0 DO
      template = DELSTR(template,col,4)
      template = SUBSTR(template,1,col-1) || path || SUBSTR(template,col)
      col = POS('%**P',template)
   ENDWHILE
   col = POS('%**D',template)
   WHILE col > 0 DO
      template = DELSTR(template,col,4)
      template = SUBSTR(template,1,col-1) || drive || SUBSTR(template,col)
      col = POS('%**D',template)
   ENDWHILE
   col = POS('%*',template)
   WHILE col > 0 DO
      template = DELSTR(template,col,2)
      template = SUBSTR(template,1,col-1) || file || SUBSTR(template,col)
      col = POS('%*',template)
   ENDWHILE

   IF gcc_translate THEN
      RETURN TRANSLATE(template,'/','\')
   ELSE
      RETURN template
   ENDIF

DEFPROC gcc_create_error_index =
   UNIVERSAL gcc_project, gcc_error_file, gcc_error_file_id,
             gcc_line2index, gcc_index2err, gcc_error_index

   /* create arrays   ------------------------------------------------------- */

   DO_ARRAY 1, gcc_line2index, 'gcc_line2index'     -- line to error number
   DO_ARRAY 1, gcc_index2err,  'gcc_index2err'      -- number to message

   current_line_this_file = .line
   GETFILEID this_file_id
   IF gcc_error_file = '' THEN                -- no compile/build, but maybe the
      IF EXIST(gcc_project'.err') THEN        -- error-file is still on disk
         gcc_error_file = gcc_project'.err'
      ELSEIF EXIST(SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'err') THEN
         gcc_error_file = SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'err'
      ELSE
         SAYERROR 'No compile/build-results available. Use Compile/Build first.'
         RETURN 3
      ENDIF
   ENDIF
   IF gcc_error_file_id = '' THEN
      'EDIT /d' gcc_error_file
      GETFILEID gcc_error_file_id
   ELSEIF this_file_id <> gcc_error_file_id THEN
      ACTIVATEFILE gcc_error_file_id
   ENDIF

   /* parse whole file and fill arrays   ------------------------------------ */

   SAYERROR 'Parsing errors ...'
   current_line_error_file = .line
   .line = 1
   .col  = 1
   'gcc_parse_error all'
   .line = current_line_error_file

   limit = ''
   DO_ARRAY 7, gcc_index2err, 0, limit
   IF limit <> '' THEN
      gcc_error_index = 1
      rc = 0
   ELSE
      SAYERROR 'No compile errors!'
      rc = 2
   ENDIF
   ACTIVATEFILE this_file_id
   .line = current_line_this_file
   RETURN rc


DEFPROC gcc_display_error =
   UNIVERSAL gcc_index2err, gcc_error_index

   DO_ARRAY 7, gcc_index2err, 'line.'gcc_error_index, lineno
   DO_ARRAY 7, gcc_index2err, 'col.'gcc_error_index, col
   DO_ARRAY 7, gcc_index2err, 'len.'gcc_error_index, len
   DO_ARRAY 7, gcc_index2err, 'file.'gcc_error_index, filename
   DO_ARRAY 7, gcc_index2err, 'msg.'gcc_error_index, gcc_message

   "EDIT" TRANSLATE(filename,'\','/') "'gcc_setpos "lineno col len"'"
   SAYERROR gcc_message

DEFPROC gcc_delete_arrays =
   UNIVERSAL gcc_line2index, gcc_index2err, gcc_error_index

   IF gcc_line2index <> '' THEN
      GETFILEID this_file_id
      ACTIVATEFILE gcc_line2index
      'XCOM QUIT'
      ACTIVATEFILE gcc_index2err
      'XCOM QUIT'
      ACTIVATEFILE this_file_id
      gcc_line2index  = ''
      gcc_index2err   = ''
      gcc_error_index = 0
   ENDIF
