/*
ͻ
 What's it called: EPMGCC  V3.30                                              
                                                                              
 What does it do:  The E source code for the GCC-Interface for EPM.           
                   This file contains definition of common constants used     
                   by gcc.e and gccactn.e. This file should be included after 
                   gccenv.e.                                                  
                                                                              
 Who and When:     B. Bablok 12/93 - 12/96                                    
                                                                              
ͼ

Ŀ
  Defining default constants if not defined in GCCENV.E                       

*/

COMPILE IF not defined(GCC_MENU_ALWAYS_ON)
   CONST   GCC_MENU_ALWAYS_ON = 0              --  default is to grey out GCC-
COMPILE ENDIF                                  --  menu for non c/cc files

COMPILE IF not defined(GCC_EXTENSIONS)         --  keep C_EXTENSIONS and
   COMPILE IF not defined(C_EXTENSIONS)        --  CPP_EXTENSIONS in sync with
      CONST   C_EXTENSIONS = 'C H SQC'         --  ckeys.e
   COMPILE ENDIF
   COMPILE IF not defined(CPP_EXTENSIONS)
      CONST   CPP_EXTENSIONS = 'CPP HPP CXX HXX SQX JAV JAVA'
   COMPILE ENDIF
   CONST   GCC_EXTENSIONS = C_EXTENSIONS CPP_EXTENSIONS 'NRX'   -- extensions
COMPILE ENDIF                                  --  which enable GCC-menu

COMPILE IF not defined(GCC_D_COMPILE_OPTIONS)
   CONST   GCC_D_COMPILE_OPTIONS = '-c -g %*'  --  default: compile and create
COMPILE ENDIF                                  --  debug information

COMPILE IF not defined(GCC_P_COMPILE_OPTIONS)
   CONST GCC_P_COMPILE_OPTIONS = '-O2 -o %**P%**N.exe %*' --  default: compile
COMPILE ENDIF                                             --  with optimization
                                                          --  and link

COMPILE IF not defined(GCC_D_BUILD_OPTIONS)
   CONST   GCC_D_BUILD_OPTIONS = '-k -f %* MODE=D' -- default debug build option
COMPILE ENDIF

COMPILE IF not defined(GCC_P_BUILD_OPTIONS)
   CONST   GCC_P_BUILD_OPTIONS = '-k -f %* MODE=P' -- default production build
COMPILE ENDIF                                      -- options

COMPILE IF not defined(GCC_AUTOSAVE_FILE)
   CONST   GCC_AUTOSAVE_FILE = 1               --  default is to turn on smart
COMPILE ENDIF                                  --  save before compile

COMPILE IF not defined(GCC_DEBUG_MODE)
   CONST   GCC_DEBUG_MODE = 1                  -- default is to turn on debug -
COMPILE ENDIF                                  -- mode

COMPILE IF not defined(GCC_VERBOSE_MODE)
   CONST   GCC_VERBOSE_MODE = 0                -- default is to turn off verbose
COMPILE ENDIF                                  -- mode

COMPILE IF not defined(GCC_REMOVE_MODE)
   CONST   GCC_REMOVE_MODE = 0                 -- default is to turn off auto-
COMPILE ENDIF                                  -- remove of .err-files

COMPILE IF not defined(GCC_SETTINGS_MODE)
   CONST   GCC_SETTINGS_MODE = 1               -- default is to save settings
COMPILE ENDIF                                  -- at exit

COMPILE IF not defined(GCC_EDIT_COMMAND)
   CONST   GCC_EDIT_COMMAND = 'start /c /win epro'
COMPILE ENDIF

COMPILE IF not defined(GCC_COMP_COMMAND)
   CONST   GCC_COMP_COMMAND = 'start /n /win gcc'
COMPILE ENDIF

COMPILE IF not defined(GCC_BUILD_COMMAND)
   CONST   GCC_BUILD_COMMAND = 'start /n /win make'
COMPILE ENDIF

COMPILE IF not defined(GCC_DEBUG_COMMAND)
   CONST   GCC_DEBUG_COMMAND = 'start /n /win gdb'
COMPILE ENDIF

COMPILE IF not defined(GCC_WANT_TRANSLATE)
   CONST   GCC_WANT_TRANSLATE = 1
COMPILE ENDIF

COMPILE IF not defined(GCC_PARSER_MODULE)
   CONST   GCC_PARSER_MODULE = 'gccparse'
COMPILE ENDIF

/*
Ŀ
   English language support for GCC menu and toolbar help                      

*/
CONST
  GCC_MENU__MSG      = \1'Menus related to GCC support'
  GCC_OPEN__MSG      = \1'Open (define) the current project'
  GCC_SEL__MSG       = \1'Select the current project from previous projects'
  GCC_EDIT__MSG      = \1'Edit the current project'
  GCC_SELECT__MSG    = \1'Select compiler'
  GCC_CLOSE__MSG     = \1'Close the current project'
  GCC_COMP_OPT__MSG  = \1'Set compile options'
  GCC_COMP__MSG      = \1'Compile the current file'
  GCC_BUILD_OPT__MSG = \1'Set build options'
  GCC_BUILD__MSG     = \1'Build the current project'
  GCC_VIEW__MSG      = \1'View compile results'
  GCC_RUN__MSG       = \1'Run EXE - file'
  GCC_DEBUG__MSG     = \1'Debug EXE - file'
  GCC_DEBUGMODE__MSG = \1'Toggle debug-mode'
  GCC_AUTOSAVE__MSG  = \1'Toggle autosave mode'
  GCC_VERBOSE__MSG   = \1'Verbose mode for troubleshooting GCC commands'
  GCC_REMOVE__MSG    = \1'Toggle automatic removing of .err files from edit-ring'
  GCC_SETTINGS__MSG  = \1'Toggle saving of settings in epm.ini'
  GCC_PREV_ERR__MSG  = \1'Show previous compiler error'
  GCC_CURR_ERR__MSG  = \1'Show current compiler error'
  GCC_NEXT_ERR__MSG  = \1'Show next compiler error'
