# RPM SPEC file for Alliance
# (C) 2000, Czo [Olivier Sirol]
# -*- vim: set filetype=spec: -*-
# rpm -ba /var/tmp/czo/rpm/SPECS/alliance.spec
# avec $HOME/.rpmmacros :
# %_topdir    /var/tmp/czo/rpm
# $Id: myspec,v 1.2 2002/06/28 10:36:09 czo Exp $

%define  name     alliance
%define  prefix   /usr/local/alliance
%define  version  5.0
%define  release  20031001


Name:           %{name}
Version:        %{version}
Release:        %{release}
Source:         %{name}-%{version}-%{release}.tar.gz
Summary:        Alliance, a free VLSI CAD System
Url:            http://www-asim.lip6.fr/alliance/
Copyright:      LGPL/GPL
Vendor:         LIP6
Packager:       Czo <Olivier.Sirol@lip6.fr>
Group:          Applications/VLSI
Buildroot:      /var/tmp/root-%{name}-%{version}-%{release}

%description

Alliance is a complete set of  free CAD tools and portable libraries for
VLSI design. It includes a  VHDL compiler and simulator, logic synthesis
tools, and automatic  place and route tools. A complete  set of portable
CMOS libraries is  provided. Alliance is the result of a ten year effort
spent at  ASIM departement  of LIP6  laboratory of  the Pierre  et Marie
Curie  University  (Paris  VI,  France).  Alliance  has  been  used  for
research  projects such  as the  875 000  transistors StaCS  superscalar
microprocessor and 400 000 transistors IEEE Gigabit HSL Router.

%prep
%setup -q

%build
 if [ -d %{buildroot} ]; then rm -rf %{buildroot}; fi

%install
# As we use libraries for tools that we build in the same run, we have to
# do the "install" step within the "build" step.

ALLIANCE_TOP=%{buildroot}/%{prefix}
export ALLIANCE_TOP

./configure --prefix=%{prefix}
make DESTDIR=%{buildroot} install

%post
 ln -sf %{prefix}/etc/alc_env.sh  /etc/profile.d
 ln -sf %{prefix}/etc/alc_env.csh /etc/profile.d

%preun
 if [ $1 -eq 0 ]; then
   rm -f /etc/profile.d/alc_env.sh
   rm -f /etc/profile.d/alc_env.csh
 fi

%clean
 if [ -d %{buildroot} ]; then rm -rf %{buildroot}; fi

%files
%defattr(-,root,root)
%{prefix}


%changelog
* Tue Jun 25 2002 Czo <Olivier.Sirol@lip6.fr>
- real .spec from Jean-Paul Chaput's one, with same
  numbering scheme as before :
  alliance-5.0-20020624 where 20020624 is the date
  of checkout.
* Tue Jun  5 2001 Czo <Olivier.Sirol@lip6.fr>
- ./configure done on RedHat 7.1.
* Wed Feb  2 2000 Czo <Olivier.Sirol@lip6.fr>
- Packaged from the tgz distrib.

