/* FONENUM.C searches a file for a phone number using only */
/* the (supplied) lastname, and also allows additions of   */
/* names to the file when "enter" is the lastname supplied */

/* This is deliberately written with function declarations */
/* preceding function use, for strict ANSI argument checks */
/* and no need of a header file.  Things are defined in    */
/* one place only.  Globals are carefully minimized.       */

/* My formatting philosophy is to keep all of a function   */
/* on a single page and to have that deal with one thought */

#include <stdio.h>
#include <string.h>

#define MAXLASTNM   30
#define MAXFIRSTNM  15
#define MAXFONENUM  12
#define DATABASE    "input"

struct record {
  char lastname[MAXLASTNM + 1];
  char firstname[MAXFIRSTNM + 1];
  char phonenum[MAXFONENUM + 1];
  };

/* ------------------------------------ */
/* emit program calling syntax verbiage */
void
help(void) {

  puts("Usage:  FONENUM <name> ");
  puts(" Where <name> is the lastname of the person.");
  puts(" In order to add names to the file, enter the");
  puts(" word 'Enter' as the name of the person.");
  } /* help */

/* ----------------------------------------- */
/* prompt and get input string, limit length */
void
promptget(char *prompt, char *answer, int maxlgh) {
  int i;

  printf(prompt); fflush(stdin);  /* reverse order ?? */
  fgets(answer, maxlgh, stdin);

  /* There MUST be clearer and better code for the rest */
  if (answer[strlen(answer)-1] == '\n')   /* remove any trailing \n */
    answer[strlen(answer)-1] = 0;
  for (i = strlen(answer); i <= maxlgh; i++) {      /* clean string */
    answer[i] = 0;
    }
  } /* promptget */

/* ---------------------------------------------- */
/* get record data from stdin and add to database */
void
addrecords(FILE *fptr) {
  struct record currentitem;

  promptget("Enter last name:  ", currentitem.lastname, MAXLASTNM);
  promptget("Enter first name: ", currentitem.firstname, MAXFIRSTNM);
  promptget("Phone number (XXX-XXX-XXXX):  ", currentitem.phonenum,
             MAXFONENUM);
  if (0 == fwrite(&currentitem, sizeof(currentitem), 1, fptr)) {
    puts("Write failure");
    }
  } /* addrecords */


/* ---------------------------------------------- */
/* display all database records matching searchee */
void
displaymatches(FILE *fptr, char *searchee) {
  struct record currentitem;
  int           names, count;

  names = count = 0;
  while (0 != fread(&currentitem, sizeof(currentitem), 1, fptr)) {
    if (0 == strcmpi(currentitem.lastname, searchee)) {
      printf("\n%s %s:  %s", currentitem.firstname,
                             currentitem.lastname,
                             currentitem.phonenum);
      names++;
      }
    count++;
    }
  } /* displaymatches */


/* ---------------------------------- */
/* Main body and overall flow control */
void
main(int argc, char *argv[]) {
  FILE *fptr;

  if (argc != 2) help();            /* extra or no params mean misentry */
  else if (0 == strcmpi("enter", argv[1])) {                 /* loading */
    if (NULL == (fptr = fopen(DATABASE, "ab"))) {
      puts("Cannot open file for storing data.");
      }
    else {                                           /* successful open */
      addrecords(fptr);
      fclose(fptr);
      }
    }
  else if (NULL == (fptr = fopen(DATABASE, "rb"))) {       /* searching */
    puts("Cannot open file for reading data.");
    }
  else {                                             /* successful open */
    displaymatches(fptr, argv[1]);
    fclose(fptr);
    }
  } /* main */
