/********************************************************************
**  YRCLAGG.C v0.17T  Copyright (c) 1987, 1988, 1989 by Paul M. Sittler.
**
**  Produces an "AGGIE" calendar for YEARCAL.
**
**  All rights reserved.  The copyright owner hereby authorizes the
**  no-charge, noncommercial making and/or distribution of copies of
**  the entirety of this work unchanged and unincorporated in any
**  other work (except "LiBRary" or "ARChive" disk files for the sole
**  purpose of no-charge noncommercial distribution).  No other
**  reproduction or use is authorized without the express prior
**  written consent of the copyright owner.
**
**************************************************************/

/* ANSI header files included:  */
#include <stdio.h>	/* fclose, fopen, fp, fprintf, fputs, */
			/* gets, printf, rename, sprintf, stderr */
#include <stdlib.h>	/* exit */
#include <string.h>	/* strcat, strcmp, strcpy, strlen */

#include "yearcal.def"

/* External variables and structures declared in YEARCAL.C */
extern char *lingo[];			/* Names of languages array */
extern char *mnam[][12];		/* Names of months array */
extern char *wkday[][7];		/* Names of days array */
extern int yr[][12][6][7];		/* Array for 3 yrs, 4-D, */
					/* 3 years,      12 months/year, */
					/* 6 weeks/month, 7 days/week */
extern char *new_file;
extern char *file;
extern FILE *fp;



void agg_printer(int year, char out, char base, int lang, char pause)
/* char base;	Number base used, 0 = Decimal, H = Hex, O = Octal */
/* int lang;	Language used 1 = Danish, 2 = Dutch, 3 = English etc. */
/* char pause;	Page pause True/False */
{
    int mf[12][2];	/* mf flag for aggie calendar */

    char agg1[] = {" Ja Fe Mr Ap My Jn Jl Au Se Oc No De"},
	 agg2[] = {" -- -- -- -- -- -- -- -- -- -- -- --"};

    int y,
	month,
	week,
	day,
	count,
	stat,
	i,
	j;

    char  linbuf[BUF],
	  temp[BUF];

    char *off = (out == 'V') ?
			 " " :
		      "    " ;
    y = 1;				/* Make year this year */
    sprintf(agg1, " %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s",
	   mnam[lang - 1][0], mnam[lang - 1][ 1], mnam[lang - 1][ 2],
	   mnam[lang - 1][3], mnam[lang - 1][ 4], mnam[lang - 1][ 5],
	   mnam[lang - 1][6], mnam[lang - 1][ 7], mnam[lang - 1][ 8],
	   mnam[lang - 1][9], mnam[lang - 1][10], mnam[lang - 1][11] );

    if (out == 'F')
    {
	sprintf(file, "%dAGG%c", year, base);
	strcpy(new_file, file);
	strcat(file, ".$$$");
	sprintf(temp, ".%3.3s", lingo[lang - 1]);
	strcat(new_file, temp);
	fp = fopen(file, "w");
    }

    if (pause     &&			/* User wants time after each page */
	out == 'P' )			/* gets printed to add paper etc... */
	hold();				/* Wait for keystroke */

    fputs("\n\n\n", fp);
    sprintf(temp, "%sAggie %s%sGig'Em %s Calander fer %d",
		 (base == 'O') ? "Olde " : "" ,
		 base ? "Hacker's " : "" ,
		 base ? ( (base == 'O') ? "Octal " : "Hexadecimal ") : "",
		 lingo[lang - 1],
		 year);
    fputs(center(temp, out == 'V' ? 75 : 89), fp);
    fputs("\n\n\n", fp);

    for (day = 0;
	 day < 7;			/* 4 sets of days */
	 day += 2)			/* 2 days across */
    {
	 for (i = 0;
	      i < 12;			/* 12 months in a day */
	      i++)
	     for (j = 0;
		  j < 2;		/* 2 days across */
		  j++)
		 mf[i][j] = 0;

	if (day < 6)
	{
	    sprintf(linbuf, "%s%s    ", off, center(wkday[lang - 1][day], 36));
	    sprintf(temp,   "%s\n"  , center(wkday[lang - 1][day + 1], 36));
	    strcat(linbuf, temp);
	    fputs(linbuf, fp);
	    linbuf[0] = '\0';
	    fprintf(fp, "%s%s   %s\n", off, agg1, agg1);
	    fprintf(fp, "%s%s   %s\n", off, agg2, agg2);
	}
	else 				/* day = 6 */
	{
	    fprintf(fp, "%s%s\n", off, trim(center(wkday[lang - 1][day], 79) ) );
	    fprintf(fp, "%s%s\n", off, trim(center(agg1, 79) ) );
	    fprintf(fp, "%s%s\n", off, trim(center(agg2, 79) ) );
	}

	for (week = 0;
	     week < 5;			/* 5 weeks/day possible */
	     week++)
	{
	    sprintf(linbuf, off);

	    for (count = 0;		/* 2 days across except Saturday */
		 count < ( (day == 6) ?
				    1 :
				    2  );
		 count++)
	    {
		if (day == 6)		/* Saturday */
		    strcat(linbuf, "                     ");

		for (month = 0;
		     month < 12;	/* 12 months/day */
		     month++)
		{
		    if (!yr[y][month][week][day + count])
			mf[month][count] = 1;

		    sprintf(temp,
		     yr[y][month][week + mf[month][count]][day + count] ?
			    (base ?
				((base == 'O') ? "%3o" : "%3X" ) :
						 "%3d" ) :
						 "   ",
		     yr[y][month][week + mf[month][count]][day + count]);
		    strcat(linbuf, temp);
		}

		strcat(linbuf, count < 1 ?
				   "   " :
				   "\n"    );

		if (day == 6)		/* Saturday */
		    strcat(linbuf, "\n");
	    }

	    fputs(linbuf, fp);
	    linbuf[0] = '\0';
	}
	fputs("\n\n", fp);
    }

    if (out != 'V')
	fputs("\f\r", fp);		/* no FF for screen */

    if (out == 'F')			/* Setup for file output */
	if ((stat = fclose(fp)) == ERROR)
	    printf("\nCan't close %s.\n", file);

    if (out == 'F')
	if ((stat = rename(file, new_file)) == ERROR)
	    printf(
	    "\nCan't rename %s to %s.  %s may already exist.\n",
			    file, new_file,
				       new_file);
}



