


DTE(1L)               Programmer's Manual                DTE(1L)



NAME
     dte - full screen text editor

SYNOPSIS
     dte [ filename ]

DESCRIPTION
     dte is a simple full-screen text editor suitable for editing
     program source code. It was designed with goals including:
         1. To perform well over slow serial communication lines;
         2. To imitate the command keys used in WordStar /  Turbo
            Pascal.

     It is therefore expected that this editor will  be  particu-
     larly suitable for distance education students, who normally
     use Turbo Pascal (and hence are already  familiar  with  the
     keystrokes  required),  and who also normally have to log in
     via 300/1200/2400 baud modems.

     To edit a file called "test.p", use the command:
         dte test.p
     If "test.p" already exists, it will be loaded ready to edit.
     If it does not yet exist, dte will create a new empty file.

     If no file is specified, then dte will automatically display
     its  on-line  help  (which  contains most of the information
     included in this manual entry).

     In the following commands, ^x is used to represent control-x
     (this  means  holding  down the control key, and then typing
     x).

     Cursor Movement Commands:
      ^X  - line down
      ^E  - line up
      ^D  - character right
      ^S  - character left
      ^F  - word right
      ^A  - word left
      ^C  - screen down
      ^R  - screen up
      ^QC - end of file
      ^QR - beginning of file
      ^QX - bottom of screen
      ^QE - top of screen
      ^QD - end of current line
      ^QS - beginning of current line
      ^QI - start of particular line in file (dte will prompt for
            line number)
      ^QB - beginning of marked block
      ^QK - end of marked block
      ^Q0 ... ^Q9 - move to marker 0 ... 9



Printed 2/6/91           dte Version 5.1                        1






DTE(1L)               Programmer's Manual                DTE(1L)



      ^Q[ - match forwards  - works with () {} []  ''  ""  /*  */
            begin  end  [if the cursor is on one of these charac-
            ters, then it will be moved to the matched pair]
      ^Q] - match backwards - works with () {} []  ''  ""  /*  */
            begin end
      ^QF - find text in file [dte will prompt for text  to  find
            and for options - see below]
      ^QP - move to previous position

     Screen Scrolling Commands:
      ^Z  - scroll down one line
      ^W  - scroll up one line
      ^C  - scroll down one page
      ^R  - scroll up one page

     Search and Replace Commands:
      ^QF - find
      ^QA - replace
      ^L  - repeat last find/replace

     Find/Replace Options:
      U   - ignore case
      B   - search backwards
      G   - scan entire file (global)
      L   - scan marked block (local)
      N   - replace without asking
      M   - match original case when replacing
      W   - match entire words only
      <n> - perform find/replace <n> times

     Editing Search Strings (and file names):
      ^S  - move cursor left
      ^D  - move cursor right
      ^E  - move to start of string
      ^X  - move to end of string
      ^Y  - delete all of string
      ^R  - restore original string
      ^G  - delete character under cursor
      <BackSpace> - delete character to left of cursor
      printable characters are inserted at the cursor

     Block Commands:
      ^KB - mark start of block
      ^KK - mark end of block
      ^KH - hide/unhide block
      ^KC - copy marked block to cursor
      ^KV - move marked block to cursor
      ^KY - delete marked block
      ^KW - write block to file
      ^KR - read in file at cursor
      ^K@ - read in file at cursor, expanding tabs etc
      ^KP - print block or entire file



Printed 2/6/91           dte Version 5.1                        2






DTE(1L)               Programmer's Manual                DTE(1L)



      ^KI - indent block by current tab size
      ^KU - unindent block by current tab size

     File Commands:
      ^KD - save file, then exit editor
      ^KX - save file only if modified, then exit
      ^KS - save file, continue editing
      ^KT - save file under new name, continue editing
      ^KQ - exit editor without saving

     Text Insertion:
      ^N  - insert new line at cursor, leave  cursor  on  current
            line
      <Enter> - insert new line at cursor, cursor moves to  start
                of new line
      printable characters are (in insert mode) inserted in front
      of the cursor

     Text Deletion Commands:
      <BackSpace> - delete character to left of cursor, move cur-
                    sor left
      ^G  - delete character under cursor, do not move cursor
      ^Y  - delete current line
      ^QY - delete from cursor to end of line
      ^T  - delete from cursor to end of word
      ^KY - delete marked block

     Change Editing Modes:
      ^V  - insert character in front of cursor / overwrite char-
            acter at cursor
      ^OI - indent new line to match previous / start new line at
            column 0
      ^OU - <BackSpace> matches  earlier  indentation  /  deletes
            just one character

     Window Commands:
      ^OK - change to another window,  or  create  a  new  window
            below  cursor  [the new window will start on the line
            immediately below the cursor, and  continue  down  to
            the bottom line in the current window.]
      ^OM - change the size of the  current  window  [the  cursor
            line will become the new boundary between the current
            window and the one below (or  above  if  the  current
            window is the bottom window)]

     Miscellaneous Commands:
      ^U or <ESC> - abort current command
      ^J  - obtain on-screen help
      ^QL - restore current line
      ^K0 ... ^K9 - set position marker 0 ... 9
      ^\  - redraw entire display (useful if screen gets garbled)
      ^OT - set tab stop interval



Printed 2/6/91           dte Version 5.1                        3






DTE(1L)               Programmer's Manual                DTE(1L)



      ^KF - shell out to operating system

AUTHOR
     Douglas Thomson, Monash University College Gippsland.

BUG REPORTS TO
     Douglas Thomson    doug@giaea.oz
















































Printed 2/6/91           dte Version 5.1                        4



