/*
	definitions for portable CORE graphics routines
*/
#ifndef _G3
#define _G3

/*	variables holding the "current position" in world coordinates	*/

extern double cur_x, cur_y, cur_z;


/*	indirectly defined routines		*/

#define  line_abs_2(x,y)         line_abs_3((x),(y),cur_z)
#define  line_rel_2(dx,dy)       line_abs_3((dx)+cur_x,(dy)+cur_y,cur_z)
#define  line_rel_3(dx,dy,dz)    line_abs_3((dx)+cur_x,(dy)+cur_y,(dz)+cur_z)
#define  marker_abs_2(x,y)       marker_abs_3((x),(y),cur_z)
#define  marker_rel_2(x,y)       marker_abs_3((x)+cur_x,(y)+cur_y,cur_z)
#define  marker_rel_3(x,y,z)     marker_abs_3((x)+cur_x,(y)+cur_y,(z)+cur_z)
#define  move_abs_2(x,y)         move_abs_3((x),(y),cur_z)
#define  move_rel_2(dx,dy)       move_abs_3((dx)+cur_x,(dy)+cur_y,cur_z)
#define  move_rel_3(dx,dy,dz)    move_abs_3((dx)+cur_x,(dy)+cur_y,(dz)+cur_z)
#define  viewport2(x1,x2,y1,y2)  viewport3((x1),(x2),(y1),(y2),0.,1.)


/*	predefined line types	*/

#define  SOLID   0
#define  DASHED  1
#define  DOTTED  2
#define  DASHDOT 3

#ifndef MODEL
#ifdef __LARGE__
#define MODEL far
#else
#define MODEL
#endif
#endif /* MODEL */

         MODEL initialize_view_surface( int mode ); 
         MODEL reset_line( ); 
         MODEL idline( int x1, int y1, int x2, int y2 ); 
         MODEL iwline( int x1, int y1, int x2, int y2 ); 
         MODEL ierase( int x2, int y2 ); 
         MODEL icerase( int a1, int a2, int b1, int b2 );
         MODEL icline( int a1, int a2, int b1, int b2 );
         MODEL window( double xmin, double xmax, double ymin, double ymax ); 
         MODEL view_up_2( double dx, double dy ); 
         MODEL view_up_3( double dx, double dy, double dz ); 
         MODEL view_reference_point( double x, double y, double z ); 
         MODEL view_plane_normal( double dx, double dy, double dz ); 
         MODEL view_plane_distance( double v ); 
         MODEL set_view_depth( double front_distance, double back_distance );
         MODEL viewport3( double xmin, double xmax, double ymin, double ymax, double zmin, double zmax );
         MODEL text( char *s ); 
         MODEL terminate_view_surface( ); 
         MODEL terminate_core( ); 
         MODEL set_marker_symbol( int n ); 
         MODEL set_linewidth( int w ); 
         MODEL set_linestyle( int style ); 
         MODEL set_back_plane_clipping( int i ); 
         MODEL set_front_plane_clipping( int i ); 
         MODEL set_charsize( double cw, double ch );
         MODEL set_charplane( double dx, double dy, double dz );
         MODEL set_charup_2( double dx, double dy ); 
         MODEL set_charup_3( double dx, double dy, double dz );
         MODEL set_charpath( int i ); 
         MODEL set_charspace( double x ); 
         MODEL set_charjust( int i ); 
         MODEL set_charprecision( int i ); 
         MODEL select_view_surface( int mode ); 
         MODEL polymarker_rel_2( double *x, double *y, int n ); 
         MODEL polymarker_rel_3( double *x, double *y, double *z, int n ); 
         MODEL polymarker_abs_2( double *x, double *y, int n ); 
         MODEL polymarker_abs_3( double *x, double *y, double *z, int n ); 
         MODEL polygon_rel_2( double *x, double *y, int n ); 
         MODEL polygon_rel_3( double *x, double *y, double *z, int n ); 
         MODEL polygon_abs_2( double *x, double *y, int n ); 
         MODEL polygon_abs_3( double *x, double *y, double *z, int n ); 
         MODEL polyline_rel_2( double *x, double *y, int n ); 
         MODEL polyline_rel_3( double *x, double *y, double *z, int n ); 
         MODEL polyline_abs_2( double *x, double *y, int n ); 
         MODEL polyline_abs_3( double *x, double *y, double *z, int n ); 
         MODEL perspective( double x, double y, double z ); 
         MODEL parallel( double x, double y, double z ); 
         MODEL new_frame( );
         MODEL ndc_space_2( double w, double h );
         MODEL ndc_space_3( double w, double h, double d ); 
         MODEL move_abs_3( double x, double y, double z ); 
         MODEL marker_abs_3( double x, double y, double z ); 
         MODEL inquire_open_temporary_segment( );
         MODEL inquire_window( double *x1, double *x2, double *y1, double *y2 ); 
         MODEL inquire_viewport_3( double *xmin, double *xmax, double *ymin, double *ymax, double *zmin, double *zmax );
         MODEL inquire_viewport_2( double *xmin, double *xmax, double *ymin, double *ymax );
         MODEL inquire_ndc_space_3( double *w, double *h, double *d );
         MODEL inquire_ndc_space_2( double *w, double *h ); 
         MODEL inquire_linestyle( int *n );
         MODEL inquire_linewidth( int *n );
         MODEL inquire_marker_symbol( int *n );
         MODEL inquire_current_position_2( double *x, double *y );
         MODEL inquire_current_position_3( double *x, double *y, double *z ); 
double   MODEL inquire_charspace( );
int      MODEL inquire_charpath( ); 
int      MODEL inquire_charjust( );
int      MODEL inquire_charprecision( ); 
         MODEL inquire_charup_3( double *dx, double *dy, double *dz ); 
         MODEL inquire_charup_2( double *dx, double *dy ); 
         MODEL inquire_charplane( double *dx, double *dy, double *dz ); 
         MODEL inquire_charsize( double *cw, double *ch ); 
         MODEL initialize_core( int out, int in, int dimension );
         MODEL coordinate_system_type( int i );
         MODEL close_temporary_segment( );
         MODEL clip_window( int i );

#endif /* _G3 */
