/*
 *      config.c: Read the configuration files for smail/PC
 *
 *      Stephen C. Trier
 *      March 26, 1990
 *
 *      This file was written entirely by Stephen C. Trier
 *      and is in the public domain.
 */

/*
 *      This is where the UUPC dependencies come out of the woodwork.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "config.h"

#define RCVAR(A)    ((A == 0) ? "UUPCSYSRC" : "UUPCUSRRC")

void ms_config(struct table_entry table[])
{
    char line[81];
    char *rcfile;
    FILE *fp;
    int i, j;

    for (i = 0; i < 2; i++)  {
	rcfile = getenv(RCVAR(i));
	if (rcfile == NULL)  {
	    fprintf(stderr, "smail: $%s must be defined.\n", RCVAR(i));
	    exit(5);
	    }
	fp = fopen(rcfile, "r");
	while (!feof(fp))  {
	    fgets(line, 80, fp);
	    *strchr(line, '\n') = '\0';  /* Chop off the newline */
	    for (j = 0; table[j].n != NULL; j++) /* Check each table entry */
		/* If the keyword for this table entry matches this line, */
		if (strnicmp(line, table[j].n, strlen(table[j].n)) == 0)  {
		    /* Copy its value into the proper variable. */
		    *(table[j].v) = strdup(line + strlen(table[j].n) + 1);
		}
	    }
	fclose(fp);
	}
}

