/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
/***************************************************************************
 *   Copyright (C) 2005 by Linares Georges
 *   georges.linares@archipel-software.com
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or  (at your option) 
 *    any later version.
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the  Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 ***************************************************************************/
#include <qtimer.h>
#include <qprocess.h>
#include <qinputdialog.h> 

#include "form1.h"

extern QProcess  *  proc;
extern QString  * ScanningFolder;
QString ligne;
int counter=1;
int cptObj = 0;
int cptVir = 0;
int cpt = 0;
int compteur = 0;
int valchaine;
QVariant recupObj;
QVariant recupVir;
QTimer *instant  = new QTimer();
QString essai;

//heure 
int s=0;
int m=0;
int h=0;
QTimer *temps  = new QTimer();
QString cpt_s;
QString cpt_m;
QString cpt_h;
QString heure;

void frmAnalyse::init()
{
    connect( proc, SIGNAL(readyReadStdout()), this, SLOT(lectureSortie()));
    connect( proc, SIGNAL(processExited()), this, SLOT(changeLabel()) );
    connect( instant, SIGNAL(timeout()), SLOT(progression()) );   
    connect( temps, SIGNAL(timeout()), SLOT(etat()) );
    temps->start( 1000, FALSE);
    instant->start( 25000, FALSE);
}

void frmAnalyse::progression()
{
    counter+=1;
    pbScanNow->setProgress(counter);
}

void frmAnalyse::tuer_proc()
{
    proc->tryTerminate();
    QTimer::singleShot( 1000, proc, SLOT( kill() ) );
    counter=1;
    compteur=0;
    cpt = 0;
    cptVir = 0;
    cptObj = 0;
    s=0;
    m=0;
    h=0;
    temps->disconnect();
    close();
}

void frmAnalyse::test()
{
    if (ligne.startsWith("Results"))
    {
	ligne = proc->readLineStdout()+"\n";
	for (cpt=0;cpt<7;cpt++)
	{ 
	   ligne += proc->readLineStdout()+"\n";
                 }
	teStats->append(ligne);    
    }
}

void frmAnalyse::lectureSortie()
{  
    essai = "";
    do 
    {
	leListFile->clear();
	ligne = proc->readLineStdout();
	test();
	if (ligne.startsWith("/"))
	{
                   QString test1 = ligne.mid(0,30);
	   QString test2 = ligne.right(25);
	   QString test3 = test1 +" ... "+ test2;
                   leListFile->setText(test3);
	   NbObject();
	   if (ligne.contains("infected")>0)
	   {
	       valchaine = ligne.find(':',0,false);
	       ligne.truncate(valchaine); 
	       essai = ligne + "\n";
	       textEdit3->append(essai);
	       cptVir += 1;
	       recupVir.asInt() = cptVir;
	       textLabel1->setText(recupVir.toString());
	   }
                }
    }
    while (proc->canReadLineStdout());
    
}

void frmAnalyse::etat()
{
    s=s+1;
    cpt_s = cpt_s.setNum( s );
    //sec->setText("0"+cpt_s + tr("  Sec"));
    sec->setText("0"+cpt_s);
    if (s>9)
    {
         sec->setText(cpt_s);
     }
    if (s>=60)
    {
	s=0;
	m=m+1;
                cpt_s = cpt_s.setNum( s );
                //sec->setText(cpt_s + tr("  Sec"));
                sec->setText(cpt_s);		
	cpt_m = cpt_m.setNum ( m );
	//min->setText(cpt_m + tr("  Min"));
	min->setText("0"+cpt_m+tr(":"));
    }
    if (m>9)
    {
       min->setText(cpt_m+tr(":"));	
    }
    if (m>=60)
    {
	m=0;
	h=h+1;
                cpt_s = cpt_s.setNum( s );
                //sec->setText(cpt_s + tr("  Sec"));
                sec->setText(cpt_s);		
	cpt_m = cpt_m.setNum ( m );
	//min->setText(cpt_m + tr("  Min"));
	min->setText(cpt_m);
	cpt_h = cpt_m.setNum (h);
	//heu->setText(cpt_h + tr("  Heures"));
	heu->setText("0"+cpt_h+tr(":"));
    }
    heure=cpt_h+cpt_m+cpt_s;

}


void frmAnalyse::changeLabel()
{
     if (instant->isActive())
    {
        temps->disconnect();
        compteur = compteur - cptVir;
        recupObj.asInt() = compteur;
        lblCountObject->setText(recupObj.toString());  
        instant->stop();	
        pbScanNow->setProgress(100);
        lblAnalyse->setText(tr("Analyse termine !"));
        leListFile->clear();
        btnCancel->setTextLabel(tr("Fermer"));
    }
    counter=1;
    compteur=0;
    cpt = 0;
    instant->stop();
}

void frmAnalyse::NbObject()
{
       compteur += 1;
       recupObj.asInt() = compteur;
       lblCountObject->setText(recupObj.toString());  
}
