#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <limits.h>
#include <sys/stat.h>
#include <ctype.h>
#include <errno.h>
#include "xutil.h"
#include "lutil.h"
#include "bwrite.h"
#include "session.h"
#include "ftn.h"
#include "config.h"

#ifdef FBOX
#include <dirent.h>
#endif

#ifndef PATH_MAX
#define PATH_MAX 512
#endif

enum
{
  DSP_LEAVE,
  DSP_TFS,
  DSP_KFS,
  DSP_DSF
} Dispositions;

extern int master;
int made_request;

extern FILE *openpkt(FILE *,faddr*,char);
extern char *pktname(faddr*,char);
extern char *floname(faddr*,char);
extern char *reqname(faddr*,char);
extern char *splname(faddr*,char);
extern long sequencer(void);

static char *tmpkname(void);
static char *tmpkname(void)
{
	static char buf[16];
	sprintf(buf,"%08lx.pkt",sequencer());
	return buf;
}


/**
 * Add the specified entry to the list of files which should be sent
 * to the remote system.
 * @param lst file list to add entry to
 * @param local local file name
 * @param remote remote file name
 * @param disposition disposition
 * @param floff offset of entry in flo-file (-1 if this entry is a flo-file)
 * @param flofp FILE * of flo-file
 * @param toend append or prepend to list
 */
void add_list(file_list **lst, char *local, char *remote,
	      int disposition, off_t floff, FILE *flofp,
	      int toend);

void add_list(file_list **lst, char *local, char *remote,
	      int disposition, off_t floff, FILE *flofp,
	      int toend)
{
	file_list **tmpl;
	file_list *tmp;

	debug(DBG_FILELIST,"add_list(\"%s\",\"%s\",%d,%s)",
	      S(local),S(remote),disposition,toend?"to end":"to beg");
	if (toend) for (tmpl=lst;*tmpl;tmpl=&((*tmpl)->next));
	else tmpl=&tmp;
	*tmpl=(file_list*)xmalloc(sizeof(file_list));
	if (toend)
	{
		(*tmpl)->next=NULL;
	}
	else
	{
		(*tmpl)->next=*lst;
		*lst=*tmpl;
	}
	if ((remote_flags & SESSION_FNC) == 0)
	{
	  debug(DBG_FILELIST, "No filename conversion for \"%s\"", S(remote));
	  (*tmpl)->remote = xstrcpy(remote);
	}
	else
	{
	  (*tmpl)->remote = xtodos(remote);
	  debug(DBG_FILELIST, "name \"%s\" converted to \"%s\"", S(remote), S((*tmpl)->remote));
	}
	(*tmpl)->local=xstrcpy(local);
	(*tmpl)->disposition=disposition;
	(*tmpl)->floff=floff;
	(*tmpl)->flofp=flofp;
	return;
}

static void check_flo(file_list**,char*);
static void check_flo(lst,nm)
file_list **lst;
char *nm;
{
	FILE *fp;
	off_t off;
	struct flock fl;
	char buf[PATH_MAX],buf2[PATH_MAX],*p,*q;
	int disposition;
	struct stat stbuf;
	dos_map *dmap;
#ifdef AMIGADOS_4D_OUTBOUND
	struct stat st;
	char namebuf[13], *ext;
#endif

	debug(DBG_FILELIST,"check_flo(\"%s\")",S(nm));
	if ((fp=fopen(nm,"r+")) == NULL)
	{
		debug(DBG_FILELIST,"no flo file");
		return;
	}
	fl.l_type=F_RDLCK;
	fl.l_whence=0;
	fl.l_start=0L;
	fl.l_len=0L;
	if (fcntl(fileno(fp),F_SETLK,&fl) != 0)
	{
		if (errno != EAGAIN)
			logerr("$cannot read-lock \"%s\"",S(nm));
		else debug(DBG_FILELIST,"flo file busy");
		fclose(fp);
		return;
	}
	if (stat(nm,&stbuf) != 0)
	{
		logerr("$cannot access \"%s\"",S(nm));
		fclose(fp);
		return;
	}

	while (!feof(fp) && !ferror(fp))
	{
		off=ftell(fp);
		if (fgets(buf,sizeof(buf)-1,fp) == NULL) continue;
		if (buf[0] == '~') continue; /* skip sent files */
		if (*(p=buf+strlen(buf)-1) == '\n') *p--='\0';
		if (*p == '\r') *p='\0';
		switch (buf[0])
		{
		case '#':	p=buf+1; disposition=DSP_TFS; break;
		case '-':
		case '^':	p=buf+1; disposition=DSP_KFS; break;
		case '@':	p=buf+1; disposition=DSP_LEAVE; break;
		case 0:		continue;
		default:	p=buf; disposition=DSP_LEAVE; break;
		}

		for ( dmap = dosmap; dmap; dmap = dmap->next ) {
			if (strncasecmp(p,dmap->drive,strlen(dmap->drive)) == 0) {
				strcpy(buf2,dmap->path);
				for (p+=strlen(dmap->drive),q=buf2+strlen(buf2);*p;p++,q++) 
					*q=((*p) == '\\')?'/':tolower(*p);
				*q='\0';
				p=buf2;
				break;
			}
		}
/*
		if (dosoutbound &&
		    (strncasecmp(p,dosoutbound,strlen(dosoutbound)) == 0))
		{
		  strcpy(buf2,outbound);
		  for (p+=strlen(dosoutbound),q=buf2+strlen(buf2);
		       *p;p++,q++)
		    *q=((*p) == '\\')?'/':tolower(*p);
		  *q='\0';
		  p=buf2;
		}
*/
		if ((q=strrchr(p,'/'))) q++;
		else q=p;
#ifdef AMIGADOS_4D_OUTBOUND
		if(!stat(p, &st))
		{
			ext = strrchr(p,'.');
			sprintf(namebuf,"%08x%s", st.st_ctime, ext);
			q=namebuf;
		}
#endif
		add_list(lst,p,q,disposition,off,fp,1);
	}

	/* add flo-file to file list */
	add_list(lst, nm, NULL, DSP_KFS, -1L, fp, 1);

	/* here, we leave .flo file open, it will be closed by */
	/* execute_disposition */

	return;
}

#ifdef FBOX
faddr *FindInAlist (fa_list * flst, faddr * fadr)
{
  fa_list *tmpl;

  for (tmpl = flst; tmpl; tmpl = tmpl->next)
    {
      debug (12, "try to find in list %s", ascfnode (tmpl->addr, 0x1f));
      if ((tmpl->addr->zone == fadr->zone) &&
	  (tmpl->addr->net == fadr->net) &&
	  (tmpl->addr->node == fadr->node) &&
	  (tmpl->addr->point == fadr->point))
	{
	  return tmpl->addr;
	}
    }
  return NULL;
}
#endif


file_list *create_filelist(al,fl,create)
fa_list *al;
char *fl;
int create;
{
	file_list *st=NULL,*tmpf;
	fa_list *tmpa;
	char flavor, *tmpfl;
	char *nm;
	char tmpreq[13];
	struct stat stbuf;
	int packets=0;
	FILE *fp;
#ifdef FBOX
	faddr *tmpaddr;
	DIR *dir;
	struct dirent *dire;
	char *p, *q;
#endif

	if test_verbose(DBG_FILELIST) debug(DBG_FILELIST,"create_filelist(%s,\"%s\",%d)",
	      al?ascfnode(al->addr,0x1f):"<none>",
	      S(fl),create);
	made_request=0;

	for (tmpa=al;tmpa;tmpa=tmpa->next)
	{
		if (strchr(fl, 'o'))
		{
			nm=splname(tmpa->addr,'o');
			if ((fp=fopen(nm,"w"))) fclose(fp);
			if ((nm != NULL) && (stat(nm,&stbuf) == 0))
			{
				add_list(&st,nm,NULL,DSP_DSF,0L,NULL,1);
			}
		}

		tmpfl = fl;
		while ((flavor = *tmpfl++))
		{
		  if ((flavor == 'o') || (flavor == 'c') || (flavor == 'h'))
		    nm=pktname(tmpa->addr,toupper(flavor));
		  else
		    nm=pktname(tmpa->addr,flavor);
		  if ((nm != NULL) && (stat(nm,&stbuf) == 0))
		  {
		    packets++;
		    add_list(&st,nm,tmpkname(),DSP_KFS,0L,NULL,1);
		  }

		  nm=floname(tmpa->addr,flavor);
		  check_flo(&st,nm);
		}

		if ((session_flags & SESSION_WAZOO) &&
		    ((session_flags & SESSION_HYDRA) == 0) &&
		    (master || ((session_flags & SESSION_IFNA) == 0)))
		if (strchr(fl, 'o')) /* we don't distinguish flavoured reqs */
		{
			nm=reqname(tmpa->addr,'o');
			if ((nm != NULL) && (stat(nm,&stbuf) == 0))
			{
				sprintf(tmpreq,"%04X%04X.REQ",
					tmpa->addr->net,tmpa->addr->node);
				add_list(&st,nm,tmpreq,DSP_DSF,0L,NULL,1);
				made_request=1;
			}
		}
	}

	if (((st == NULL) && (create > 1)) ||
	    ((st != NULL) && (packets == 0) && (create > 0)))
	{
		if test_verbose(DBG_FILELIST) debug(DBG_FILELIST,"create packet for %s",ascfnode(al->addr,0x1f));
		if ((fp=openpkt(NULL,al->addr,'O')))
		{
			iwrite(0,fp);
			fclose(fp);
		}
		add_list(&st,pktname(al->addr,'O'),tmpkname(),DSP_KFS,0L,NULL,0);
	}
#ifdef FBOX
/*        */
  for (tmpa = al; tmpa; tmpa = tmpa->next)
    {
      debug (12, "process outbox for %s", ascfnode (tmpa->addr, 0x1f));
      if ((tmpaddr = FindInAlist (OutBox, tmpa->addr)))
	{
	  p = xstrcpy (tmpaddr->name);
	  p = xstrcat (p, "/");
	  debug (12, "box is \"%s\"", p);
	  if (!(dir = opendir (p)))
	    {
	      logerr ("$error in scan outbox \"%s\"", p);
	      continue;
	    }
	  while ((dire = readdir (dir)))
	    {
	      q = xmalloc (strlen (p) + strlen (dire->d_name) + 1);
	      strcpy (q, p);
	      strcat (q, dire->d_name);
	      if (stat (q, &stbuf))
		continue;
	      if (!(S_ISREG (stbuf.st_mode)))
		continue;
	      add_list (&st, q, dire->d_name, DSP_KFS, 0L, NULL, 1);
	      free (q);
	    }
	  free (p);
	}
    }
#endif

	for (tmpf=st;tmpf;tmpf=tmpf->next)
	if test_verbose(DBG_FILELIST) debug(DBG_FILELIST,"flist: \"%s\" -> \"%s\" dsp:%d flofp:%lu floff:%lu",
	      S(tmpf->local),S(tmpf->remote),tmpf->disposition,
	      tmpf->flofp,tmpf->floff);

	return st;
}

file_list *create_freqlist(fa_list *al);
file_list *create_freqlist(fa_list *al)
{
  file_list *st=NULL, *tmpf;
  fa_list *tmpa;
  char *nm;
  char tmpreq[13];
  struct stat stbuf;

  if test_verbose(DBG_FILELIST) debug(DBG_FILELIST,"create_freqlist(%s)",
	al?ascfnode(al->addr,0x1f):"<none>");
  made_request=0;

  for (tmpa=al;tmpa;tmpa=tmpa->next)
  {
    nm=reqname(tmpa->addr,'o');
    if ((nm != NULL) && (stat(nm,&stbuf) == 0))
    {
      sprintf(tmpreq,"%04X%04X.REQ",
	      tmpa->addr->net,tmpa->addr->node);
      add_list(&st,nm,tmpreq,DSP_DSF,0L,NULL,1);
      made_request=1;
    }
  }

  for (tmpf=st;tmpf;tmpf=tmpf->next)
    if test_verbose(DBG_FILELIST) debug(DBG_FILELIST,"flist: \"%s\" -> \"%s\" dsp:%d flofp:%lu floff:%lu",
	  S(tmpf->local),S(tmpf->remote),tmpf->disposition,
	  tmpf->flofp,tmpf->floff);

  return st;
}

void tidy_filelist(fl,dsf)
file_list *fl;
int dsf;
{
	file_list *tmp;

	for (tmp=fl;fl;fl=tmp)
	{
		tmp=fl->next;
		if (dsf && (fl->disposition == DSP_DSF))
		{
			debug(DBG_FILELIST,"removing sent file \"%s\"",S(fl->local));
			if (unlink(fl->local) != 0)
				if (errno == ENOENT)
					debug(DBG_FILELIST,"cannot unlink nonexistent file \"%s\"",
					      S(fl->local));
				else
					logerr("$cannot unlink file \"%s\"",
					       S(fl->local));
		}
		if (fl->local) free(fl->local);
		if (fl->remote) free(fl->remote);
		else if (fl->flofp) fclose(fl->flofp);
		free(fl);
	}
	return;
}

void execute_disposition(fl)
file_list *fl;
{
	FILE *fp=NULL;
	char *nm;
	char tpl='~';


	nm=fl->local;

	if (fl->flofp)
	{
	  /* check for special case: flo-file */
	  if (fl->floff == -1)
	  {
	    /*
	     * We check if there are any files left for transmission
	     * in the flo-file to decide whether to remove or leave it 
	     * on disk
	     */
	    char buf[PATH_MAX];
	    int files_remain = 0;


	    if (fseek(fl->flofp, 0L, 0) == 0)
	    {
	      while (!feof(fl->flofp) && !ferror(fl->flofp))
	      {
		if (fgets(buf, sizeof(buf)-1, fl->flofp) == NULL)
		  continue;

		/* count nr of files which haven't been sent yet */
		if (buf[0] != '~')
		  files_remain++;
	      }
	    }
	    else
	    {
	      logerr("$error seeking in .flo to 0");
	      files_remain = -1; /* keep flo-file */
	    }

	    if (files_remain)
	    {
	      debug(DBG_FILELIST, "leaving flo-file \"%s\", %d files remaining",
		    S(nm), files_remain);
	      fl->disposition = DSP_LEAVE;
	    }
	    else
	    {
	      fl->disposition = DSP_KFS;
	    }
	  }
	  else
	  {
	    /* mark file as sent in flo-file */
	    if (fseek(fl->flofp,fl->floff,0) == 0)
	    {
	      if (fwrite(&tpl,1,1,fl->flofp) != 1)
	      {
		logerr("$error writing '~' to .flo at %lu",
		       (unsigned long) fl->floff);
	      }

	      fflush(fl->flofp);
#ifdef HAS_FSYNC
	      fsync(fileno(fl->flofp));
#endif
	    }
	    else
	    {
	      logerr("$error seeking in .flo to %lu",
		     (unsigned long) fl->floff);
	    }
	  }
	}

	switch (fl->disposition)
	{
	 case DSP_DSF:
	 case DSP_LEAVE:
	  debug(DBG_FILELIST, "leaving sent file \"%s\"", S(nm));
	  break;

	 case DSP_TFS:
	  debug(DBG_FILELIST, "truncating sent file \"%s\"", S(nm));
	  if ((fp = fopen(nm, "w")))
	  {
	    fclose(fp);
	  }
	  else
	  {
	    logerr("$cannot truncate file \"%s\"", S(nm));
	  }
	  break;

	 case DSP_KFS:
	  debug(DBG_FILELIST, "removing sent file \"%s\"", S(nm));

	  if (unlink(nm) != 0)
	  {
	    if (errno == ENOENT)
	    {
	      debug(DBG_FILELIST, "cannot unlink nonexistent file \"%s\"",
		    S(nm));
	    }
	    else
	    {
	      logerr("$cannot unlink file \"%s\"",
		     S(nm));
	    }
	  }
	  break;

	default:
	  logerr("execute_disposition: unknown disp %d for \"%s\"",
		 fl->disposition, S(nm));
	  break;
	}
	return;
}
