#!/usr/bin/perl

$SyncNode = "2:5020/99999\@fidonet";
$SyncLog  = "/var/log/ifmail/OLD/inb.1.iflog.0";
$TimeDiffMin = 5;
$TimeDiffMax = 3570;
$Newsgroup = "fido7.20.ROBOTS";
$ErrorTo = "To: postmaster\nCc: SysOp\@f99999.n5020.z2.fidonet.org\n";

if( !open( logfile, $SyncLog )) {
	die "Cannot open logfile $SyncLog\n";
}

$sess = 0;
while( <logfile> ) {
	chop;
	( $lmon, $lday, $ltime, $dummy1, $dummy2, $str ) = split( /[ \t]+/, $_, 6 );
	if( $str =~ /start[ \t]+inbound/ ) {
		$sess = 0;
		next;
	}
	if( $str =~ /start[ \t]+outbound/ ) {
		$sess = 0;
		next;
	}
	if( $sess == 0 ) {
		if( $str =~ /remote[ \t]+address:/ ) {
			( $dummy1, $dummy2, $Node ) = split( /[ \t]+/, $str );
			$sess = 1 if( $Node eq $SyncNode );
		}
		next;
	} elsif( $sess == 1 ) {
		if( $str =~ /remote[ \t]+time:/ ) {
			( $dummy1, $dummy2, $Rmon, $Rday, $Rtime ) = split( /[ \t]+/, $str );
			$Lmon = $lmon;
			$Lday = $lday;
			$Ltime = $ltime;
			$sess = 2;
		}
		next;
	} elsif( $sess == 2 ) {
		if( $str =~ /remote gave correct password/ ) {
			$LocalMon[$#LocalMon+1] = $Lmon;
			$LocalDay[$#LocalDay+1] = $Lday;
			$LocalTime[$#LocalTime+1] = $Ltime;
			$RemoteMon[$#RemoteMon+1] = $Rmon;
			$RemoteDay[$#RemoteDay+1] = $Rday;
			$RemoteTime[$#RemoteTime+1] = $Rtime;
			$sess = 0;
		}
		next;
	}
}
close( logfile );

$lastsess = $#LocalTime;
( $lh, $lm, $ls ) = split ( /:/, $LocalTime[$lastsess] );
( $rh, $rm, $rs ) = split ( /:/, $RemoteTime[$lastsess] );
$l = (( $lh * 60 ) + $lm ) * 60 + $ls;
$r = (( $rh * 60 ) + $rm ) * 60 + $rs;
$timediff = $l - $r;
$timediff *= -1 if( $timediff < 0 );

if( $timediff > $TimeDiffMax ) {
	if( !open( msg, "|/usr/lib/news/inews -h" )) {
		print "Error of posting news...\n";
		exit( 1 );
	}
	print msg "From: Time_corrector\n";
	print msg "Newsgroups: $Newsgroup\n";
	print msg "Subject: WARNING! Too more different time\n\n";
	print msg "Local time  - $LocalTime[$lastsess]\n";
	print msg "Remote time - $RemoteTime[$lastsess]\n";
	print msg "Difference of time $timediff seconds.\n";
	print msg "\nDon't corrected!\n";
	close( msg );

	if( !open( msg, "|/usr/lib/sendmail -t" )) {
		print "Error of sending mail...\n";
		exit( 1 );
	}
	print msg "From: Time_corrector\n";
	print msg $ErrorTo;
	print msg "Subject: WARNING! Too more different time\n\n";
	print msg "Local time  - $LocalTime[$lastsess]\n";
	print msg "Remote time - $RemoteTime[$lastsess]\n";
	print msg "Difference of time $timediff seconds.\n";
	print msg "\nDon't corrected!\n";
	close( msg );
} elsif( $timediff > $TimeDiffMin ) {
	$newtime = time() - ( $l - $r );
	@loctime = localtime( $newtime );
	$str = sprintf( "%02d%02d%02d%02d.%02d", $loctime[4]+1, $loctime[3], $loctime[2], $loctime[1], $loctime[0] );
	system( "/bin/date $str >/dev/null 2>&1" );
	system( "/sbin/clock -wu" );
	if( !open( msg, "|/usr/lib/news/inews -h" )) {
		print "Error of posting news...\n";
		exit( 1 );
	}
	print msg "From: Time_corrector\n";
	print msg "Newsgroups: $Newsgroup\n";
	print msg "Subject: Local time corrected with $SyncNode\n\n";
	print msg "Local time  - $LocalTime[$lastsess]\n";
	print msg "Remote time - $RemoteTime[$lastsess]\n";
	print msg "Difference of time $timediff seconds.\n\n";
	print msg "Corrected to remote time.\n";
	close( msg );
}
