/*
*  Synopsis: profile [-u username] [-b binno] [-t tsoid]
*                    [-v vmid] [-d dept] [-s defsh] [-h homedir]
*
*  With no arguments, profile displays the contents of the fifth
*  field in the /etc/passwd file for the user.  If arguments are
*  given, it updates the field with the given information.
*
*  The -u flag allows specification of a different username (only
*  the super-user may update a different user's record).
*/
#include <stdio.h>
#include <pwd.h>
#include <ctype.h>
#include <signal.h>

char    tfile[] = "/usr/spool/ptmp";
char    pfile[] = "/etc/passwd";

int     updt, ruid;
int     bflg, tflg, vflg, dflg, sflg, hflg;
char    uname[10], binno[10], tsoid[12], vmid[12];
char    dept [10], defsh[30], homedir[30];
struct  passwd *i;
struct  passwd *getpwuid();
struct  passwd *getpwnam();

char    usage[] = "Usage: profile [-u username] [-b binno] [-t tsoid]";
char    usag2[] = "       [-v vmid] [-d dept] [-s defsh] [-h homedir]";


main(argc, argv) char **argv;
{
        while(--argc > 0 && *argv[1]=='-') {
                argv++;
                while(*++*argv) switch(**argv) {
                        case 'b':
                                strcpy(binno, *++argv);
                                --argc;
                                ++updt;
                                ++bflg;
                                goto nextarg;
                        case 't':
                                strcpy(tsoid, *++argv);
                                --argc;
                                ++updt;
                                ++tflg;
                                goto nextarg;
                        case 'v':
                                strcpy(vmid, *++argv);
                                --argc;
                                ++updt;
                                ++vflg;
                                goto nextarg;
                        case 'd':
                                strcpy(dept, *++argv);
                                --argc;
                                ++updt;
                                ++dflg;
                                goto nextarg;
                        case 's':
                                strcpy(defsh, *++argv);
                                --argc;
                                ++updt;
                                ++sflg;
                                goto nextarg;
                        case 'h':
                                strcpy(homedir, *++argv);
                                --argc;
                                ++updt;
                                ++hflg;
                                goto nextarg;
                        case 'u':
                                strcpy(uname, *++argv);
                                --argc;
                                goto nextarg;
                        default:
                                printf("%s\n%s\n", usage, usag2);
                                exit(1);
                }
nextarg:;
        }

        if(argc != 0) {
                printf("%s\n%s\n", usage,usag2);
                exit(1);
        }
        ruid = getuid();
        if (uname[0] && updt && ruid!=0) {
                printf("Permission denied.\n");
                exit(1);
        }

        if (uname[0])
                i = getpwnam(uname);
        else
                i = getpwuid(ruid);
        if (i==0) {
                printf("Not valid user.\n");
                exit(1);
        }

        if (!updt)
                display();
        else
                update();
        exit(0);
}


display()
{
        printf("dept  tsoid    vmid     binno  shell     homedir\n");
        printf("%4s  %7s  %7s  %3s    %8s  %s\n",
        i->pw_dept,
        i->pw_tsoid,
        i->pw_vmid,
        i->pw_binno,
        i->pw_shell[0] ? i->pw_shell : "/bin/sh",
        i->pw_dir);
}


update()
{
        char buf[202];
        int  len;
	FILE *tfd;
	FILE *pfd;

        verify();

        signal(SIGHUP,SIG_IGN);
        signal(SIGINT,SIG_IGN);
        signal(SIGQUIT,SIG_IGN);
        if (stat(tfile, buf) >= 0) {
                printf("Temporary file busy -- try again\n");
                exit(1);
        }
        if ((tfd = fopen(tfile, "w")) == NULL) {
                printf("Cannot open temporary file\n");
                exit(1);
        }
        if ((pfd = fopen(pfile, "r")) == NULL) {
                printf("Cannot open /etc/passwd file\n");
                goto out;
        }
        while (fgets(buf, 200, pfd)!=NULL) {
                len = strlen(buf);
                if (buf[len-1]!='\n')
                        goto ill;
                if (eqname(i->pw_name, buf))
                        makerec(buf);
                fputs(buf, tfd);
        }
        fclose(tfd);
        fclose(pfd);
        if ((tfd = fopen(tfile, "r")) == NULL) {
                printf("Urk\n");
                goto out;
        }
        if ((pfd = fopen(pfile, "w")) == NULL) {
                printf("Cannot create /etc/passwd file\n");
                goto out;
        }
        while (fgets(buf, 200, tfd) != NULL)
                fputs(buf, pfd);
        fclose(pfd);
        fclose(tfd);
        unlink(tfile);
        return;

ill:    printf("Passwd file illformed!\n");
out:    unlink(tfile);
        exit(1);
}


eqname(s1, s2) char *s1, *s2;
{
        while(*s1++ == *s2++) ;
        if ((*--s1 == NULL)  &&  (*--s2 == ':'))
                return(1);
        return(0);
}


makerec(buf) char *buf;
{
        sprintf(buf, "%s:%s:%d:%d:%s,%s,%s,%s:%s:%s\n",
        i->pw_name,
        i->pw_passwd,
        i->pw_uid,
        i->pw_gid,
        i->pw_dept,
        i->pw_vmid,
        i->pw_tsoid,
        i->pw_binno,
        i->pw_dir,
        i->pw_shell);
}


verify()
{
        int  error;

        error = 0;
        if (bflg) {
                if (binno[0] && strlen(binno)!=3 ) {
                        printf("Invalid binno=%s\n", binno);
                        error++;
                }
                i->pw_binno = binno;
        }
        if (tflg) {
                if (tsoid[0] && strlen(tsoid)>7) {
                        printf("Invalid tsoid=%s\n", tsoid);
                        error++;
                }
                i->pw_tsoid = tsoid;
        }
        if (vflg) {
                if (vmid[0] && strlen(vmid)>8) {
                        printf("Invalid vmid=%s\n", vmid);
                        error++;
                }
                i->pw_vmid = vmid;
        }
        if (dflg) {
                if (dept[0] && (strlen(dept)!=4 || !number(dept))) {
                        printf("Invalid dept=%s\n", dept);
                        error++;
                }
                i->pw_dept = dept;
        }
        if (sflg) {
                if (defsh[0] && access(defsh, 01) < 0) {
                        printf("Shell %s not executable\n", defsh);
                        error++;
                }
                i->pw_shell = defsh;
        }
        if (hflg) {
                if (homedir[0] && access(homedir, 07) < 0) {
                        printf("Bad home directory %s\n", homedir);
                        error++;
                }
                i->pw_dir = homedir;
        }
        if (error)
                exit(1);
}


number(s)  char *s;
{
        while (*s)
                if (!isdigit(*s++))
                        return(0);
        return(1);
}
