#include <stdio.h>
#include <sgtty.h>
#include <ctype.h>
#include "tapmotion.h"

#define  EOS     '\0'

struct  cmds    {
	char    *c_cmd;
	int     c_val;
};
struct  cmds    noargtbl[] = {
	"rew", REW,
	"run", RUN,
	"dse", DSE,
	NULL,  NULL
};
struct  cmds    argstbl[] = {
	"wtm", WTM,
	"bsb", BSB,
	"bsf", BSF,
	"fsb", FSB,
	"fsf", FSF,
	NULL,  NULL
};
struct  cmds    motion[] = {
	"rewopen",      REWOPEN,
	"rewclose",     REWCLOSE,
	"runclose",     RUN,
	"-rewopen",     REWOPEN,
	"-rewclose",    REWCLOSE,
	"_runclose",    RUN,
	NULL,           NULL
};

char    usage[] = "\
Usage: tm tape [rewopen]    [wtm [n]]  [rew]\n\
	       [rewclose]   [fsf [n]]  [run]\n\
	       [runclose]   [bsf [n]]  [dse]\n\
	       [-rewopen]   [fsb [n]]\n\
	       [-rewclose]  [bsb [n]]\n\
	       [-runclose]\n";

char    devtape[] = "/dev/tape/";
extern  char    *cmdname;


main(argc, argv)
int     argc;
char    **argv;
{
	struct  cmds    *tcmd;
	struct  cmds    *search();
	char    *tape;
	char    tapename[100];
	char    *cmd;
	int     state[2];
	int     mot;
	int     fd;
	int     i, n;

	if (argc <= 1) {
		fprintf(stderr, usage);
		exit(1);
	}
	argv++;
	tape = *argv++;
	argc--;
	if (tape[0] == '/')
                strcpy(tapename, tape);
	else {
                strcpy(tapename, devtape);
		strcat(tapename, tape);
	}
	if ((fd = open(tapename, 0)) == -1) {
		fprintf(stderr, "%s: cannot open %s\n", cmdname, tapename);
		exit(1);
	}
	while(--argc) {
		cmd = *argv++;
                tcmd = search(cmd, noargtbl);
		if (tcmd != NULL) {
			ioctl(fd, TAPIO, tcmd->c_val);
			continue;
		}
		tcmd = search(cmd, argstbl);
		if (tcmd != NULL) {
			n = 1;
			if (argc > 0 && isnum(*argv)) {
				argc--;
				n = atoi(*argv++);
			}
			for (i = 0; i < n; i++)
				ioctl(fd, TAPIO, tcmd->c_val);
			continue;
		}
		tcmd = search(cmd, motion);
		if (tcmd != NULL) {
			ioctl(fd, TAPGTTY, &state);
			if (tcmd->c_cmd[0] == '-')
				mot = state[1] & ~tcmd->c_val;
			else
				mot = state[1] | tcmd->c_val;
			ioctl(fd, TAPMOTION, mot);
		} else {
			fprintf(stderr, usage);
		}
	}
	close(fd);
}

/*
 *  search - search a table for an entry.
 *  Return NULL if entry not found.
 */
struct  cmds    *
search(name, tbl)
char    *name;
struct  cmds    *tbl;
{
	while(tbl->c_cmd != NULL) {
		if (strcmp(name, tbl->c_cmd) == 0)
			return(tbl);
		tbl++;
	}
	return(NULL);
}

/*
 *  isnum - see if a string is numeric
 */
isnum(str)
char    *str;
{
	while(*str != EOS) {
		if (!isdigit(*str))
			return(0);
		str++;
	}
	return(1);
}
