/*
*  Switch accounting files, but only if the new file has been
*  truncated to zero bytes.
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <sys/acctfile.h>

char *fn;
char fn2[100];
struct stat stx, sty;

main()
{
	extern errno;
	int  c;
        FILE *fd;
	char *fp, mesg[100];

	fn = fn2; /* the big fix */
	/* get accounting file name */
	fd = fopen("/etc/acctfile", "r");
	if(fd == NULL)
		notify("adm", "Cannot open /etc/acctfile", 1);
	else {
		fp = fn;
		while((c = getc(fd)) != '\n') {
			if (c == EOF) {
				notify("adm", "Cannot read /etc/acctfile",
					1);
				break;
			}
			*fp++ = c;
		}
		*fp = NULL;
		fclose(fd);
	}

	/* check that it is valid */
	if (strcmp(fn,filex)!=0 && strcmp(fn,filey)!=0) {
		/* nope, so pick most recently updated */
		stat(filex, &stx);
		stat(filey, &sty);
		if(stx.st_mtime < sty.st_mtime)
			fn = filey;
		else
			fn = filex;
		sprintf(mesg, "Bad acct file!!  Acctsw used %s",
			fn);
		notify("adm", mesg, 1);
	}

	if (strcmp(fn,filex)==0)
		fn = filey;
	else
		fn = filex;

	if(stat(fn, &stx)) {
		if(creat(fn, 0644) < 0) {
			sprintf(mesg, "acctsw: cannot create %s!", fn);
			notify("adm", mesg, 1);
			exit(1);
		}
	}
	if(stx.st_size > 0) {
		sprintf(mesg, "Cannot acctsw! %s not zero length", fn);
		notify("adm", mesg, 1);
		exit(1);
	}

	/* write accounting file name */
	fd = fopen("/etc/acctfile", "w");
	if(fd == NULL) {
		printf("cannot acctsw\n");
		exit(1);
	}
	else {
		fputs(fn, fd);
		fputc('\n', fd);
		fclose(fd);
	}

	/* and don't forget to tell kernel */
	if(acct(fn))
		notify("adm", "acctsw: \"acct\" call failed!", 1);
}
