#
/*
 *	 C object code improver
 */

#include "c2.h"
#include <sys/types.h>
#include <ctype.h>

struct optab optab[] = {
	"b",    JBR,
	"bo",   CBR | 1<<8,
	"bh",   CBR | 2<<8,
	"bp",   CBR | 2<<8,
	"bc 3,", CBR | 3<<8,
	"bl",   CBR | 4<<8,
	"bm",   CBR | 4<<8,
	"bc 5,", CBR | 5<<8,
	"bc 6,", CBR | 6<<8,
	"bne",  CBR | 7<<8,
	"bnz",  CBR | 7<<8,
	"bz",   CBR | 8<<8,
	"be",   CBR | 8<<8,
	"bc 9,", CBR | 9<<8,
	"bc 10,", CBR | 10<<8,
	"bnl",  CBR | 11<<8,
	"bnm",  CBR | 11<<8,
	"bc 12,", CBR | 12<<8,
	"bnh",  CBR | 13<<8,
	"bnp",  CBR | 13<<8,
	"bno",  CBR | 14<<8,
	"nop",  NOP,
	".text", TEXT,
	".data", DATA,
	".bss", BSS,
	"drop", EROU,
	"entry", ENTRY,
	"using", USING,
	"ltorg", LTORG,
	".comm", COMM,
	"ds", DS,
	"ar", ADD | REG<<8,
	"a", ADD,
	"ah", ADD | HALF<<8,
	"al", ADDL,
	"alr", ADDL | REG<<8,
	"nr", AND | REG<<8,
	"n", AND,
	"ni", NI,
	"nc", NC,
	"balr", BALR,
	/* bcr */
	"nopr",  BCR | 0<<8,
	"bor",   BCR | 1<<8,
	"bhr",   BCR | 2<<8,
	"bpr",   BCR | 2<<8,
	"bcr 3,", BCR | 3<<8,
	"blr",   BCR | 4<<8,
	"bmr",   BCR | 4<<8,
	"bcr 5,", BCR | 5<<8,
	"bcr 6,", BCR | 6<<8,
	"bner",  BCR | 7<<8,
	"bnzr",  BCR | 7<<8,
	"bzr",   BCR | 8<<8,
	"ber",   BCR | 8<<8,
	"bcr 9,", BCR | 9<<8,
	"bcr 10,", BCR | 10<<8,
	"bnlr",  BCR | 11<<8,
	"bnmr",  BCR | 11<<8,
	"bcr 12,", BCR | 12<<8,
	"bnhr",  BCR | 13<<8,
	"bnpr",  BCR | 13<<8,
	"bnor",  BCR | 14<<8,
	"br",    BCR | 15<<8,
	"bctr", BCTR,
	"cr", CMP | REG<<8,
	"c", CMP,
	"ch", CMP | HALF<<8,
	"clr", CMPL | REG<<8,
	"cl", CMPL,
	"clc", CLC,
	"cli", CLI,
	"clm", CLM,
	"clcl", CLCL,
	"cvb", CVB,
	"cvd", CVD,
	"dr", DIV | REG<<8,
	"d", DIV,
	"xr", XOR | REG<<8,
	"x", XOR,
	"xi", XI,
	"xc", XC,
	"ic", IC,
	"icm", ICM,
	"lr", LOAD | REG<<8,
	"l", LOAD,
	"la", LA,
	"ltr", LTR,
	"lcr", LCR,
	"lh", LOAD | HALF<<8,
	"lm", LM,
	"lnr", LNR,
	"lpr", LPR,
	"mc", MC,
	"mvi", MVI,
	"mvc", MVC,
	"mvcl", MVCL,
	"m", MULT,
	"mr", MULT | REG<<8,
	"mh", MULT | HALF<<8,
	"or", OR | REG<<8,
	"o", OR,
	"oi", OI,
	"oc", OC,
	"spm", SPM,
	"slda", SLDA,
	"sldl", SLDL,
	"sla", SLA,
	"sll", SLL,
	"srda", SRDA,
	"srdl", SRDL,
	"sra", SRA,
	"srl", SRL,
	"st", STORE,
	"stc", STORE | CHAR<<8,
	"stcm", STCM,
	"sth", STORE | HALF<<8,
	"stm", STM,
	"sr", SUB | REG<<8,
	"s", SUB,
	"sh", SUB | HALF<<8,
	"slr", SUBL | REG<<8,
	"sl", SUBL,
	"svc", SVC,
	"ts", TS,
	"tm", TM,
	"tr", TR,
	"trt", TRT,
	"adr", FADD | (REG+DBL)<<8,
	"ad", FADD | DBL<<8,
	"aer", FADD | (REG+SNGL)<<8,
	"ae", FADD | SNGL<<8,
	"awr", FADD | (REG+DBL+UNNRM)<<8,
	"aw", FADD | (DBL+UNNRM)<<8,
	"aur", FADD | (REG+SNGL+UNNRM)<<8,
	"au", FADD | (SNGL+UNNRM)<<8,
	"cdr", FCMP | (REG+DBL)<<8,
	"cd", FCMP | DBL<<8,
	"cer", FCMP | (REG+SNGL)<<8,
	"ce", FCMP | SNGL<<8,
	"ddr", FDIV | (REG+DBL)<<8,
	"dd", FDIV | DBL<<8,
	"der", FDIV | (REG+SNGL)<<8,
	"de", FDIV | SNGL<<8,
	"hdr", FHALF | (REG+DBL)<<8,
	"her", FHALF | (REG+SNGL)<<8,
	"ltdr", FLTR | (REG+DBL)<<8,
	"lter", FLTR | (REG+SNGL)<<8,
	"lcdr", FLCR | (REG+DBL)<<8,
	"lcer", FLCR | (REG+SNGL)<<8,
	"lpdr", FLPR | (REG+DBL)<<8,
	"lper", FLPR | (REG+SNGL)<<8,
	"ldr", FLOAD | (REG+DBL)<<8,
	"ld", FLOAD | DBL<<8,
	"ler", FLOAD | (REG+SNGL)<<8,
	"le", FLOAD | SNGL<<8,
	"mdr", FMULT | (REG+DBL)<<8,
	"md", FMULT | DBL<<8,
	"mer", FMULT | (REG+SNGL)<<8,
	"me", FMULT | SNGL<<8,
	"std", FSTORE | DBL<<8,
	"ste", FSTORE | SNGL<<8,
	"sdr", FSUB | (REG+DBL)<<8,
	"sd", FSUB | DBL<<8,
	"ser", FSUB | (REG+SNGL)<<8,
	"se", FSUB | SNGL<<8,
	"swr", FSUB | (REG+DBL+UNNRM)<<8,
	"sw", FSUB | (DBL+UNNRM)<<8,
	"sur", FSUB | (REG+SNGL+UNNRM)<<8,
	"su", FSUB | (SNGL+UNNRM)<<8,
	0,	0};

#define revbr(x) (15-x)

int	isn	= 20000;
int	lastseg	= -1;

main(argc, argv)
char **argv;
{
	register int niter, maxiter, isend;
	extern end;
	int nflag;
	char *cp;

	if (argc>1 && argv[1][0]=='+') {
		argc--;
		argv++;
		debug++;
	}
	nflag = 0;
	if (argc>1 && argv[1][0]=='-') {
		cp = &argv[1][1];
		while(*cp) switch(*cp++) {
		case 'v': /* verbose */
			nflag++;
			break;
		case 'O': /* always present if invoked from 'cc' */
			break;
		}
		argc--;
		argv++;
	}
	if (argc>1) {
		if (freopen(argv[1], "r", stdin) == NULL) {
			fprintf(stderr, "C2: can't find %s\n", argv[1]);
			exit(1);
		}
	}
	if (argc>2) {
		if (freopen(argv[2], "w", stdout) == NULL) {
			fprintf(stderr, "C2: can't create %s\n", argv[2]);
			exit(1);
		}
	}
	lasta = firstr = lastr = sbrk(sizeof lasta);
	maxiter = 0;
	opsetup();
	do {
		isend = input();
	        movedat();
		niter = 0;
		do {
			refcount();
			do {
				iterate();
				niter++;
			} while (nchange);
			comjump();
		        rmove();
		} while (nchange || jumpsw());
	      /*addsob();*/
		output();
		if (niter > maxiter)
			maxiter = niter;
		lasta = firstr;
	} while (isend);
	if (nflag) {
		fprintf(stderr, "%d iterations\n", maxiter);
		fprintf(stderr, "%d jumps to jumps\n", nbrbr);
		fprintf(stderr, "%d inst. after jumps\n", iaftbr);
		fprintf(stderr, "%d jumps to next inst\n", njp1);
		fprintf(stderr, "%d redundant labels\n", nrlab);
		fprintf(stderr, "%d cross-jumps\n", nxjump);
		fprintf(stderr, "%d code motions\n", ncmot);
		fprintf(stderr, "%d branches reversed\n", nrevbr);
		fprintf(stderr, "%d redundant loads & stores\n", redunm);
		fprintf(stderr, "%d loops inverted\n", loopiv);
		fprintf(stderr, "%d redundant jumps\n", nredunj);
		fprintf(stderr, "%d common seqs before jmp's\n", ncomj);
		fprintf(stderr, "%d skips over jumps\n", nskip);
		fprintf(stderr, "%d literals eliminated\n", nlit);
		fprintf(stderr, "%d RX to RR\n", nrxrr);
		fprintf(stderr, "%d redundant LTRs\n", nltr);
		fprintf(stderr, "%dK core\n", (((int)lastr+01777)>>10)&037777);
	}
	exit(0);
}

input()
{
	register struct node *p, *lastp;
	register int oper;

	lastp = &first;
	for (;;) {
		oper = getline();
		switch (oper&0377) {
	
		case LABEL:
			p = (struct node *)alloc(sizeof first);
			if (line[0] == CLAB && isdigit(line[1])) {
				p->op = LABEL;
				p->subop = 0;
				p->labno = getnum(line+1);
				p->code = 0;
			} else {
				p->op = DLABEL;
				p->subop = 0;
				p->labno = 0;
				p->code = copy(1, line);
			}
			break;
	
		case JBR:
		case CBR:
		case JSW:
			p = (struct node *)alloc(sizeof first);
			p->op = oper&0377;
			p->subop = oper>>8;
			if (*curlp == CLAB && (p->labno = getnum(curlp+1)))
				p->code = 0;
			else {
				p->labno = 0;
				p->code = copy(1, curlp);
			}
			break;

		default:
			p = (struct node *)alloc(sizeof first);
			p->op = oper&0377;
			p->subop = oper>>8;
			p->labno = 0;
			p->code = copy(1, curlp);
			break;

		}
		p->forw = 0;
		p->back = lastp;
		lastp->forw = p;
		lastp = p;
		p->ref = 0;
		if (oper==EROU)
			return(1);
		if (oper==END)
			return(0);
	}
}

getline()
{
	register char *lp;
	register c;
	int incomment = 0;

	lp = line;
	while ((c = getchar()) == ' ' || c == '\t' || c == '\n')
		;
	do {
		if(c == '/')
			incomment = 1;
		if (c==':' && !incomment) {
			*lp++ = 0;
			return(LABEL);
		}
		if (c=='\n') {
			*lp++ = 0;
			return(oplook());
		}
		if (lp >= &line[LSIZE-2]) {
			fprintf(stderr, "C2: Sorry, input line too long\n");
			exit(1);
		}
		*lp++ = c;
	} while ((c = getchar()) != EOF);
	*lp++ = 0;
	return(END);
}

getnum(ap)
char *ap;
{
	register char *p;
	register n, c;

	p = ap;
	n = 0;
	while ((c = *p++) >= '0' && c <= '9')
		n = n*10 + c - '0';
	if (*--p != 0)
		return(0);
	return(n);
}

output()
{
	register struct node *t;
	register struct optab *oper;

	t = &first;
	while (t = t->forw) switch (t->op) {

	case END:
		return;

	case LABEL:
		printf("%c%d:\n", CLAB, t->labno);
		continue;

	case DLABEL:
		printf("%s:\n", t->code);
		continue;

	case TEXT:
	case DATA:
	case BSS:
		lastseg = t->op;

	default:
		for (oper = optab; oper->opstring!=0; oper++) 
			if ((oper->opcode&0377) == t->op
			 && (oper->opcode>>8) == t->subop) {
				printf("%s", oper->opstring);
				break;
			}
		if (t->code) {
			printf("\t%s\n", t->code);
		} else if (t->op==JBR || t->op==CBR)
			printf("\t%c%d\n", CLAB, t->labno);
		else
			printf("\n");
		continue;

	case JSW:
		printf("dc a(%c%d)\n", CLAB, t->labno);
		continue;

	case DC:
		printf("dc %s\n", t->code);
		continue;

	case 0:
		if (t->code)
			printf("%s", t->code);
		printf("\n");
		continue;
	}
}

/*VARARGS*/
char *
copy(na, ap)
char *ap;
{
	register char *p, *np;
	char *onp;
	register n;

	p = ap;
	n = 0;
	if (*p==0)
		return(0);
	do
		n++;
	while (*p++);
	if (na>1) {
		p = (&ap)[1];
		while (*p++)
			n++;
	}
	onp = np = alloc(n);
	p = ap;
	while (*np++ = *p++)
		;
	if (na>1) {
		p = (&ap)[1];
		np--;
		while (*np++ = *p++);
	}
	return(onp);
}

struct optab **hash(op)
char *op;
{
	int n;

	for(n=0; *op; op++)
                n = (n << 2) ^ (*op) ^ (*op << 7);
	return(&ophash[(n & 077777) % OPHS]);
}

opsetup()
{
	register struct optab *optp, **ophp;
	register char *p;

	for (optp = optab; p = optp->opstring; optp++) {
		ophp = hash(p);
		while (*ophp++)
			if (ophp > &ophash[OPHS])
				ophp = ophash;
		*--ophp = optp;
	}
}

oplook()
{
	register struct optab *optp;
	register char *lp, *np;
	static char tmpop[32];
	struct optab **ophp;
	int n;

	if (line[0]=='\0') {
		curlp = line;
		return(0);
	}
	np = tmpop;
	for (lp = line; *lp && *lp!=' ' && *lp!='\t';)
		*np++ = *lp++;
	*np++ = 0;
	while (*lp=='\t' || *lp==' ')
		lp++;
	curlp = lp;
	ophp = hash(tmpop);
	while (optp = *ophp) {
		np = optp->opstring;
		lp = tmpop;
		while (*lp == *np++)
			if (*lp++ == 0)
				return(optp->opcode);
		ophp++;
		if (ophp >= &ophash[OPHS])
			ophp = ophash;
	}
	if(strcmp(tmpop, "dc") == 0) {
                if (strncmp(curlp, "a($", 3) == 0) { /* switch label */
                        lp = curlp + 3;
                        while (*lp && *lp != ')') {
                                if (*lp<'0' || *lp>'9')
                                        break;
				lp++;
			}
			if(*lp == 0 || *lp == ')') {
                                curlp += 2;
                                *lp = '\0'; /* for getnum */
                                return(JSW);
			}
                }
		return(DC);
	}
	if(strcmp(tmpop, "bc") == 0) {
		for(lp = curlp; *lp != ','; lp++) ;
		*lp++ = '\0';
		while(*lp == ' ' || *lp == '\t') lp++;
		n = getnum(curlp);
		curlp = lp;
		return(CBR | n<<8);
	}
	if(strcmp(tmpop, "bcr") == 0) {
		for(lp = curlp; *lp != ','; lp++) ;
		*lp++ = '\0';
		while(*lp == ' ' || *lp == '\t') lp++;
		n = getnum(curlp);
		curlp = lp;
		return(BCR | n<<8);
	}
if(debug) fprintf(stderr, "Unknown op %s\n", tmpop);
	curlp = line;
	return(0);
}

refcount()
{
	register struct node *p, *lp;
	static struct node *labhash[LABHS];
	register struct node **hp, *tp;

	for (hp = labhash; hp < &labhash[LABHS];)
		*hp++ = 0;
	for (p = first.forw; p!=0; p = p->forw)
		if (p->op==LABEL) {
			labhash[p->labno % LABHS] = p;
			p->refc = 0;
		}
	for (p = first.forw; p!=0; p = p->forw) {
		if (p->op==JBR || p->op==CBR || p->op==JSW) {
			p->ref = 0;
			lp = labhash[p->labno % LABHS];
			if (lp==0 || p->labno!=lp->labno)
			for (lp = first.forw; lp!=0; lp = lp->forw) {
				if (lp->op==LABEL && p->labno==lp->labno)
					break;
			}
			if (lp) {
				tp = nonlab(lp)->back;
				if (tp!=lp) {
					p->labno = tp->labno;
					lp = tp;
				}
				p->ref = lp;
				lp->refc++;
			}
		}
	}
        for (p = first.forw; p!=0; p = p->forw)
		if (p->op==LABEL && p->refc==0
		 && (lp = nonlab(p))->op && lp->op!=JSW && lp->op!=DC && lp->op!=DS)
			decref(p);
}

iterate()
{
	register struct node *p, *rp, *p1;

	nchange = 0;
	for (p = first.forw; p!=0; p = p->forw) {
#if O_BRBR
		if ((p->op==JBR||p->op==CBR||p->op==JSW) && p->ref) {
			rp = nonlab(p->ref);
			if (rp->op==JBR && rp->labno && p->labno!=rp->labno) {
				nbrbr++;
				p->labno = rp->labno;
				decref(p->ref);
				rp->ref->refc++;
				p->ref = rp->ref;
				nchange++;
			}
		}
#endif
#if O_SKIP
		if (p->op==CBR && (p1 = p->forw)->op==JBR) {
			rp = p->ref;
			do
				rp = rp->back;
			while (rp->op==LABEL);
			if (rp==p1) {
				decref(p->ref);
				p->ref = p1->ref;
				p->labno = p1->labno;
				p1->forw->back = p;
				p->forw = p1->forw;
				p->subop = revbr(p->subop);
				nchange++;
				nskip++;
			}
		}
#endif
		if (p->op==JBR) {
#if O_IAFTBR
			while (p->forw && p->forw->op!=LABEL
				&& p->forw->op!=DLABEL
				&& p->forw->op!=EROU && p->forw->op!=END
				&& p->forw->op!=0 && p->forw->op!=DATA) {
				nchange++;
				iaftbr++;
				if (p->forw->ref)
					decref(p->forw->ref);
				p->forw = p->forw->forw;
				p->forw->back = p;
			}
#endif
#if O_JP1
			rp = p->forw;
			while (rp && rp->op==LABEL) {
				if (p->ref == rp) {
					p->back->forw = p->forw;
					p->forw->back = p->back;
					p = p->back;
					decref(rp);
					nchange++;
					njp1++;
					break;
				}
				rp = rp->forw;
			}
#endif
		}
		if (p->op==JBR) {
			xjump(p);
			p = codemove(p);
		}
	}
}

xjump(p1)
register struct node *p1;
{
#if O_XJUMP
	register struct node *p2, *p3;

	if ((p2 = p1->ref)==0)
		return;
	for (;;) {
		while ((p1 = p1->back) && p1->op==LABEL);
		while ((p2 = p2->back) && p2->op==LABEL);
		if (!equop(p1, p2) || p1==p2)
			return;
		p3 = insertl(p2);
		p1->op = JBR;
		p1->subop = 0;
		p1->ref = p3;
		p1->labno = p3->labno;
		p1->code = 0;
		nxjump++;
		nchange++;
	}
#endif
}

struct node *
insertl(oldp)
register struct node *oldp;
{
	register struct node *lp;

	if (oldp->op == LABEL) {
		oldp->refc++;
		return(oldp);
	}
	if (oldp->back->op == LABEL) {
		oldp = oldp->back;
		oldp->refc++;
		return(oldp);
	}
	lp = (struct node *)alloc(sizeof first);
	lp->op = LABEL;
	lp->subop = 0;
	lp->labno = isn++;
	lp->ref = 0;
	lp->code = 0;
	lp->refc = 1;
	lp->back = oldp->back;
	lp->forw = oldp;
	oldp->back->forw = lp;
	oldp->back = lp;
	return(lp);
}

struct node *
codemove(p)
struct node *p;
{
	register struct node *p1, *p2, *p3;
	struct node *t, *tl;
	int n;

	p1 = p;
	if (p1->op!=JBR || (p2 = p1->ref)==0)
		return(p1);
	while (p2->op == LABEL)
		if ((p2 = p2->back) == 0)
			return(p1);
	if (p2->op!=JBR)
		goto ivloop;
#if O_CMOT
	p2 = p2->forw;
	p3 = p1->ref;
	while (p3) {
		if (p3->op==JBR) {
			if (p1==p3)
				return(p1);
			ncmot++;
			nchange++;
			p1->back->forw = p2;
			p1->forw->back = p3;
			p2->back->forw = p3->forw;
			p3->forw->back = p2->back;
			p2->back = p1->back;
			p3->forw = p1->forw;
			decref(p1->ref);
			return(p2);
		} else
			p3 = p3->forw;
	}
#endif
	return(p1);
ivloop:
#if O_LOOPIV
	if (p1->forw->op!=LABEL)
		return(p1);
	p3 = p2 = p2->forw;
	n = 16;
	do {
		if ((p3 = p3->forw) == 0 || p3==p1 || --n==0)
			return(p1);
	} while (p3->op!=CBR || p3->labno!=p1->forw->labno);
	do 
		if ((p1 = p1->back) == 0)
			return(p);
	while (p1!=p3);
	p1 = p;
	tl = insertl(p1);
	p3->subop = revbr(p3->subop);
	decref(p3->ref);
	p2->back->forw = p1;
	p3->forw->back = p1;
	p1->back->forw = p2;
	p1->forw->back = p3;
	t = p1->back;
	p1->back = p2->back;
	p2->back = t;
	t = p1->forw;
	p1->forw = p3->forw;
	p3->forw = t;
	p2 = insertl(p1->forw);
	p3->labno = p2->labno;
	p3->ref = p2;
	decref(tl);
#if O_RLAB
	if (tl->refc<=0)
		nrlab--;
#endif
	loopiv++;
	nchange++;
	return(p3);
#else
	return(p1);
#endif
}

comjump()
{
#if O_COMJ
	register struct node *p1, *p2, *p3;

	for (p1 = first.forw; p1!=0; p1 = p1->forw)
		if (p1->op==JBR && (p2 = p1->ref) && p2->refc > 1)
			for (p3 = p1->forw; p3!=0; p3 = p3->forw)
				if (p3->op==JBR && p3->ref == p2)
					backjmp(p1, p3);
#endif
}

#if O_COMJ
backjmp(ap1, ap2)
struct node *ap1, *ap2;
{
	register struct node *p1, *p2, *p3;

	p1 = ap1;
	p2 = ap2;
	for(;;) {
		while ((p1 = p1->back) && p1->op==LABEL);
		p2 = p2->back;
		if (equop(p1, p2)) {
			p3 = insertl(p1);
			p2->back->forw = p2->forw;
			p2->forw->back = p2->back;
			p2 = p2->forw;
			decref(p2->ref);
			p2->labno = p3->labno;
			p2->ref = p3;
			nchange++;
			ncomj++;
		} else
			return;
	}
}
#endif

/* moved from c21: */

jumpsw()
{
	register struct node *p, *p1;
	register t;
	register struct node *tp;
	int nj;

	t = 0;
	nj = 0;
#if O_REVBR
	for (p=first.forw; p!=0; p = p->forw)
		p->refc = ++t;
	for (p=first.forw; p!=0; p = p1) {
		p1 = p->forw;
		if (p->op == CBR && p1->op==JBR && p->ref && p1->ref
		 && abs(p->refc - p->ref->refc) > abs(p1->refc - p1->ref->refc)) {
			if (p->ref==p1->ref)
				continue;
			p->subop = revbr(p->subop);
			tp = p1->ref;
			p1->ref = p->ref;
			p->ref = tp;
			t = p1->labno;
			p1->labno = p->labno;
			p->labno = t;
			nrevbr++;
			nj++;
		}
	}
#endif
	return(nj);
}

equop(ap1, p2)
struct node *ap1, *p2;
{
	register char *cp1, *cp2;
	register struct node *p1;

	p1 = ap1;
	if (p1->op!=p2->op || p1->subop!=p2->subop)
		return(0);
	if (p1->op>0 && p1->op<NEQOP)
		return(0);
	cp1 = p1->code;
	cp2 = p2->code;
	if (cp1==0 && cp2==0)
		return(1);
	if (cp1==0 || cp2==0)
		return(0);
	while (*cp1 == *cp2++)
		if (*cp1++ == 0)
			return(1);
	return(0);
}

decref(p)
register struct node *p;
{
	if (--p->refc <= 0) {
#if O_RLAB
		nrlab++;
		p->back->forw = p->forw;
		p->forw->back = p->back;
#endif
	}
}

struct node *
nonlab(p)
struct node *p;
{
	while (p && p->op==LABEL)
		p = p->forw;
	return(p);
}

char *
alloc(n)
register n;
{
	register char *p;

	n = (n+3) & ~3;
	if (lasta+n >= lastr) {
		if (sbrk(2000) == (char *)-1) {
			fprintf(stderr, "C Optimizer: out of space\n");
			exit(1);
		}
		lastr += 2000;
	}
	p = lasta;
	lasta += n;
	return(p);
}

movedat()
{
#if O_MOVEDAT
/**** This stuff doesn't work and I don't have time to find out why

	register struct node *p1, *p2;
	struct node *p3;
	register seg;
	struct node data;
	struct node *datp;

	if (first.forw == 0)
		return;
	if (lastseg != TEXT && lastseg != -1) {
		p1 = (struct node *)alloc(sizeof(first));
		p1->op = lastseg;
		p1->subop = 0;
		p1->code = NULL;
		p1->forw = first.forw;
		p1->back = &first;
		first.forw->back = p1;
		first.forw = p1;
	}
	datp = &data;
	for (p1 = first.forw; p1!=0; p1 = p1->forw) {
		if (p1->op == DATA) {
			p2 = p1->forw;
			while (p2 && p2->op!=TEXT)
				p2 = p2->forw;
			if (p2==0)
				break;
			p3 = p1->back;
			p1->back->forw = p2->forw;
			p2->forw->back = p3;
			p2->forw = 0;
			datp->forw = p1;
			p1->back = datp;
			p1 = p3;
			datp = p2;
		}
	}
	if (data.forw) {
		datp->forw = first.forw;
		first.forw->back = datp;
		data.forw->back = &first;
		first.forw = data.forw;
	}
	seg = lastseg;
	for (p1 = first.forw; p1!=0; p1 = p1->forw) {
		if (p1->op==TEXT||p1->op==DATA||p1->op==BSS) {
			if (p2 = p1->forw) {
				if (p2->op==TEXT||p2->op==DATA||p2->op==BSS)
					p1->op  = p2->op;
			}
			if (p1->op == seg || p1->forw&&p1->forw->op==seg) {
				p1->back->forw = p1->forw;
				p1->forw->back = p1->back;
				p1 = p1->back;
				continue;
			}
			seg = p1->op;
		}
	}

*********/
#endif
}
