#include "omak.h"

int prtmode 'x';
int prtlen BPW;
int savplen 0;
int instlen 0;
int xlate 0;
int dot 0;
int dotdot 0;

struct cbuf {
       int     c_fildes;
       int     c_nleft;        /* # chars in buffer */
       char    *c_nextp;       /* next char ptr */
       char    c_buff[160];    /* buffer */
} ;
struct cbuf frog = 0;

char *prompt = "" ;
char *_str = "";

/*
   The spot that really gets control, the real main code to omak.
*/

comak(file,gpr,psw,creg,stsym)

 int file;              /* the device address to do the i/o to  */
 int *gpr;              /* pointer to Au's gpr's            */
 int *psw;              /* pointer to Au's psw              */
 int *creg;             /* pointer to Au's control reg's    */
 struct symtab *stsym;  /* symbol table pointer                 */

{
 /* The C code for Omak   */

   register int i;
   register int j;
            int k,temp,gap,l;
            char tempc;

   gpr_ptr = gpr;         /* set up the global register pointer         */
   creg_ptr = creg;       /* set up the global control register pointer */
   psw_ptr = psw;         /* set up the global psw pointer              */
   csw_ptr = 64;          /* set up the global csw pointer              */
   caw_ptr = 72;          /* set up the global caw pointer              */
   lastbp  = psw_ptr[1];  /* set up last brk pt pointer to psw addr     */
   dotdot  = psw_ptr[1];  /* init dotdot also                           */

   k = 0;
   while( stsym->name[0] != '\0' )
       {
            symtbl[k].name[0] = stsym->name[0] & 0x7f; /* strip high bit*/
            for(j = 1; j < 8; j++) symtbl[k].name[j] = stsym->name[j];
            symtbl[k].type = stsym->type;
            symtbl[k].val  = stsym->val;
            stsym++;
            k++;
        }

   symbols = &symtbl[0];   /* set up global ptr, start of symbol table*/
   symbole = &symtbl[k];   /* set up global ptr, end of symbol table  */

/* sort the symbol table by address or value */

   for (gap = k/2; gap > 0; gap /= 2)
      for (i = gap; i < k; i++)
         for (j=i-gap; j>=0 && symtbl[j].val> symtbl[j+gap].val;j -= gap)
            {
               temp = symtbl[j].val;
               symtbl[j].val = symtbl[j+gap].val;
               symtbl[j+gap].val = temp;

               temp = symtbl[j].type;
               symtbl[j].type = symtbl[j+gap].type;
               symtbl[j+gap].type = temp;

               for (l = 0; l < 8; l++)
                  {
                     tempc = symtbl[j].name[l];
                     symtbl[j].name[l] = symtbl[j+gap].name[l];
                     symtbl[j+gap].name[l] = tempc;
                   }
              }

        prompt = "Omak:";

        initio(file);   /* set up the dev address for the i/o routines */

 /* here is the call to yyparse, get the show on the road, maybe. */

        yyparse();

   /* all done, wish you had been here   */
}

aptchar()
{
	return(aptc(&frog));
}

aptc(cb)
struct cbuf *cb;
{
        int n;
        int i;
        int lbrace;
        char *c,*mcomm;

        if(cb->c_nleft == 0) {
                if((n=aptio(prompt,cb->c_buff)) <= 0) return(-1);
		c = cb->c_buff;
                lbrace=0; mcomm = &multcomm;
                while( *c != '\n') {
		     switch(*c) {
                        case('(') :
				if(*(c+1) == '<') {
					*c = '{';
				        lbrace++;
					*++c = ' ';
				}
				else if (*(c+1) == '|') {
					*c = '[';
					*++c = ' ';
				}
                               else c++;
                                break;
                        case('>') :
				if (*(c+1) == ')') {
					*c = '}';
					lbrace--;
					*++c = ' ';
                                 }
                               else c++;
                                 break;
                        case('|') :
				if (*(c+1) == ')') {
					*c = ']';
					*++c = ' ';
                                 }
                               else c++;
                                 break;
                         default:
                                /* translate upper to lower */
                                if (('A' <= (*c)) && ((*c) <= 'Z'))
                                        *c = (*c)-'A'+'a';
				 if (lbrace) *mcomm++ = *c;
                                 c++;
                                 break;
                         } /* end switch */
                    } /* end while */

                cb->c_nleft = n;
                cb->c_nextp = cb->c_buff;
        }
        cb->c_nleft--;
        return(*cb->c_nextp++);
}

/*
 * some print routines for omak
 */

setpr(v)
int v;{

	register int x, y;
	struct twoshorts { short shortx, shorty; };

	x = v.shortx;
	y = v.shorty;
	xlate = 0;
	switch(y) {
		case 0:
			break;
		case 'd':
		case 'o':
		case 'x':
			prtlen = BPW;
			prtmode = y;
			break;
		case 'c':
			prtlen = 1;
		default:
			prtmode = y;
			break;
		}
	switch(x) {
		case 'b':
			prtlen = 1;
			break;
		case 'h':
			prtlen = BPHW;
			break;
		case 'w':
			prtlen = BPW;
			break;
		case 'l':
			prtlen = BPL;
			break;
		case 'a':
			prtlen = 0;
			break;
		}
	}


prtval(addr, adflag)
register int addr;
int adflag;{

       int i;
       char text[4];
       char *txtptr;
       struct whatever { int ataddr;
                       } whatever;
       struct whatever *whatptr ;

           switch(prtmode) {
			case 'i':
			case 'j':
				dotdot = addr;
				prinst(addr,0);
                                break;
			case 't':
                                txtptr = whatptr = addr ;
				for (i=0; i<4; i++) {
                                   text[i] = *txtptr++;
                                   if (text[i] < 31 || text[i] > 127)
                                             text[i] = '.';
				}
                                aptstr(aptout, "%-6x  %08x  * %-4s *",
                                               addr,whatptr->ataddr,text);
	                        aptio(aptout,0);
                                break;
                        default:
                                whatptr = addr ;
                                aptstr(aptout, "%-6x  %08x ",
                                                addr,whatptr->ataddr);
	                        aptio(aptout,0);
                                break;
                        }
	}

printregs(str,regs)
char *str;
int *regs;
{

	register int r;
                 int g;

        for(r = 0; r < 4 ; r++)  {
              g = r*4;
              aptstr(aptout, "%s %2d   %08x  %08x  %08x  %08x ",str,g,
	       regs[r*4],regs[r*4+1],regs[r*4+2],regs[r*4+3]);
              aptio(aptout,0);
	}
  }

prtreg(r)   /* print out a register    command ;rn where n is the reg */
   register int r;
       {
              aptstr(aptout, "gpr %2d   %08x",r,gpr_ptr[r]);
              aptio(aptout,0);
	}

prtcreg(r)   /* print out a control reg, command ;cn where n is the reg */
   register int r;
        {     register int s;

              aptstr(aptout, "xr %2d   %08x",r,creg_ptr[r]);
              aptio(aptout,0);
	}

printlist(x, y)
   int *x, *y;{
                 int mod;
                 int rem;
                 struct op470 w;
                 int instrl,ii;
                 char text[16];
                 char *txtptr;

   switch(prtmode) {

case 'i': case 'j':

       mod = x;
       while(mod < y && !pa1key) {
            if (prinst(mod,0) == -1) break;

            w = *(struct op470 *)x;

            if (w.opcode <= 63) instrl = 2;
               else if ((w.opcode >= 64) && (w.opcode <= 191)) instrl = 4;
                   else instrl = 6;

            mod += instrl;
            x = mod;
        }
     pa1key = 0;
     break;

case 't':
        rem = (y-x)%4;
        for ( mod = (y-x)/4; mod > 0 && !pa1key; mod--)
                        {
                         txtptr = x;
			 for(ii=0; ii<16; ii++) {
                                text[ii] = *txtptr++;
                                if ( text[ii] < 31 || text[ii] > 127 )
                                               text[ii] = '.';
                         }
			 aptstr(aptout,
                              "%06x  %08x  %08x  %08x  %08x    * %-16s *",
                                   x,x[0],x[1],x[2],x[3],text);
                         aptio(aptout,0);
                         x += 4;
			}

       if (!pa1key)
        switch (rem) {
                        case 0:  break;
			case 1:
                         txtptr = x;
			 for(ii=0; ii<3; ii++) {
                                text[ii] = *txtptr++;
                                if ( text[ii] < 31 || text[ii] > 127 )
                                               text[ii] = '.';
                         }
                          for(ii=4; ii<16; ii++) text[ii] = ' ';
     aptstr(aptout,"%06x  %08x                                  * %16s *",
                                               x,x[0],text);
                                 aptio(aptout,0);
                                 break;
			case 2:
                         txtptr = x;
			 for(ii=0; ii<7; ii++) {
                                text[ii] = *txtptr++;
                                if ( text[ii] < 31 || text[ii] > 127 )
                                               text[ii] = '.';
                         }
                          for(ii=8; ii<16; ii++) text[ii] = ' ';
     aptstr(aptout,"%06x  %08x  %08x                        * %16s *",
                                               x,x[0],x[1],text);
                                 aptio(aptout,0);
                                 break;
			case 3:
                         txtptr = x;
			 for(ii=0; ii<11; ii++) {
                                text[ii] = *txtptr++;
                                if ( text[ii] < 31 || text[ii] > 127 )
                                               text[ii] = '.';
                         }
                          for(ii=12; ii<16; ii++) text[ii] = ' ';
     aptstr(aptout,"%06x  %08x  %08x  %08x              * %16s *",
                                       x,x[0],x[1],x[2],text);
                                 aptio(aptout,0);
                                 break;
                        default:
                               aptstr(aptout,"problem in river city%s",
					blankchr);
                               aptio(aptout,0);
	      }
            pa1key = 0;
            break;

default:

        rem = (y-x)%4;
        for ( mod = (y-x)/4; mod > 0 && !pa1key; mod--)
                        {
			 aptstr(aptout,
                                "%06x  %08x  %08x  %08x  %08x",
                                   x,x[0],x[1],x[2],x[3]);
                         aptio(aptout,0);
                         x += 4;
			}

      if (!pa1key)
        switch (rem) {
                        case 0:  break;
			case 1:  aptstr(aptout,"%06x  %08x",
                                               x,x[0]);
                                 aptio(aptout,0);
                                 break;
			case 2:  aptstr(aptout,"%06x  %08x  %08x",
                                               x,x[0],x[1]);
                                 aptio(aptout,0);
                                 break;
			case 3:  aptstr(aptout,"%06x  %08x  %08x  %08x",
                                               x,x[0],x[1],x[2]);
                                 aptio(aptout,0);
                                 break;
                        default:
                                 aptstr(aptout,"problem in river city%s",
					blankchr);
                                 aptio(aptout,0);
	      }
            pa1key = 0;
            break;
         }
      }
 
/*
 * formatted print to a string
 */
 
aptstr(str,fmt,args){
        _str = str;
        aptfmt(fmt,&args);
        *_str = '\0';
        return(str);
        }


aptfmt(fmt, ap)
register char *fmt, *ap;{

	register char *p, *q;
	char *b, *cap, buff[512];
	char c, blank;
	int *iap, i, s, t, shift;
	int leftf, width, prec, blankc, shortf;
	int mode;
	int tabber;

        tabber = 0;
	while (c = *fmt++) {
		leftf = width = 0;
		shortf = 1;
		prec = -1;
		if (c != '%') {
		        tabber++;
			*_str++ = c; /* put character into string */
			continue;
			}
		c = *fmt++;
		blank = ' ';
		if (c == '-') {
			leftf = 1;
			c = *fmt++;
			}
		if (c == '0') blank = '0';
		for (; c >= '0' && c <= '9'; c = *fmt++)
			width = 10*width+(c-'0');
		if (c == 'h') c = *fmt++;
		else if (c == 'l') {
			if ((c = *fmt++)=='d' || c=='o' || c=='x')
				c += 'A'-'a';
			}
		p = q = buff;
		cap = ap+3;
		iap = ap;
		switch(c) {
			case 'd':
				ap += 4;
				if ((i = *iap) > 0) i = -i;
				while (s = -(i/10)) {
					*p++ = '0'-(i+s*10);
					i = -s;
					}
				*p++ = '0'-i;
				if (*iap < 0 && c != 'u') *p++ = '-';
				mode = 2;
				break;

			case 's':
				cap = *iap;
				if (prec == -1) prec = 512;
				for (i = 0; *cap && i < prec; i++)
					*p++ = *cap++;
				ap += 4;
				mode = 1;
				break;


			case 'x':
				shift = 4;
				if (!leftf) blank = '0';

			case 'o':
				if (c == 'o') shift = 3;
				i = *iap;
				ap += 4;
				while (s = (i >> shift)){
					t = i-(s << shift);
					if (t >= 10) *p++ = t-10+'a';
					else *p++ = t+'0';
					i = s;
					}
				if (i >= 10) *p++ = i-10+'a';
				else *p++ = i+'0';
				mode = 2;
				break;
                       case 't':
				switch(width) {
					case(1):
                                                width = 14 - tabber;
                                                break;
					case(2):
                                                width = 20 - tabber;
                                                break;
					case(3):
                                                width = 36 - tabber;
                                                break;
				        default:
                                                 break;
                                  }
                               break;
			default:
                                tabber++;
				*_str++ = c ;
				continue;
			}
		blankc = width-(p-q);
		if (!leftf) {
                      for (i = 0; i < blankc; i++) {
                                    *_str++ = blank ;
                                    tabber++; }
                      }
		if (mode == 2)
			for (b = p-1; b >= q; --b) {
                                    tabber++;
                                    *_str++ = *b;  }
		else for (b = q; b < p; b++) {tabber++; *_str++ = *b;}
		if (leftf) {
                      for (i = 0; i < blankc; i++) {
                                   tabber++;
                                   *_str++ = blank ;  }
                      }
		}
	}
